/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityInfo;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.erosion.packet.backendbound.BackendboundBatchBlockEntityPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBatchBlockRequestPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBlockEntityPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBlockRequestPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundPickBlockPacket;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.erosion.util.LecternUtils;
import org.geysermc.geyser.erosion.GeyserboundPacketHandlerImpl;
import org.geysermc.geyser.level.GameRule;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.BlockEntityUtils;

public class GeyserWorldManager
extends WorldManager {
    private final Object2ObjectMap<String, String> gameruleCache = new Object2ObjectOpenHashMap();

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return session.getChunkCache().getBlockAt(x, y, z);
        }
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        erosionHandler.setPendingLookup(future);
        erosionHandler.sendPacket(new BackendboundBlockRequestPacket(0, Vector3i.from(x, y, z)));
        return future.join();
    }

    @Override
    public CompletableFuture<Integer> getBlockAtAsync(GeyserSession session, int x, int y, int z) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return super.getBlockAtAsync(session, x, y, z);
        }
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        int transactionId = erosionHandler.getNextTransactionId();
        erosionHandler.getAsyncPendingLookups().put(transactionId, future);
        erosionHandler.sendPacket(new BackendboundBlockRequestPacket(transactionId, Vector3i.from(x, y, z)));
        return future;
    }

    @Override
    public int[] getBlocksAt(GeyserSession session, BlockPositionIterator iter) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return super.getBlocksAt(session, iter);
        }
        CompletableFuture<int[]> future = new CompletableFuture<int[]>();
        erosionHandler.setPendingBatchLookup(future);
        erosionHandler.sendPacket(new BackendboundBatchBlockRequestPacket(iter));
        return future.join();
    }

    @Override
    public boolean hasOwnChunkCache() {
        return false;
    }

    @Override
    public void sendLecternData(GeyserSession session, int x, int z, List<BlockEntityInfo> blockEntityInfos) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return;
        }
        ObjectArrayList<Vector3i> vectors = new ObjectArrayList<Vector3i>(blockEntityInfos.size());
        for (int i = 0; i < blockEntityInfos.size(); ++i) {
            BlockEntityInfo info = blockEntityInfos.get(i);
            vectors.add(Vector3i.from(info.getX(), info.getY(), info.getZ()));
        }
        erosionHandler.sendPacket(new BackendboundBatchBlockEntityPacket(x, z, vectors));
    }

    @Override
    public void sendLecternData(GeyserSession session, int x, int y, int z) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler != null) {
            erosionHandler.sendPacket(new BackendboundBlockEntityPacket(Vector3i.from(x, y, z)));
            return;
        }
        NbtMapBuilder lecternTag = LecternUtils.getBaseLecternTag(x, y, z, 1);
        lecternTag.putCompound("book", NbtMap.builder().putByte("Count", (byte)1).putShort("Damage", (short)0).putString("Name", "minecraft:written_book").putCompound("tag", NbtMap.builder().putString("photoname", "").putString("text", "").build()).build());
        lecternTag.putInt("page", -1);
        BlockEntityUtils.updateBlockEntity(session, lecternTag.build(), Vector3i.from(x, y, z));
    }

    @Override
    public boolean shouldExpectLecternHandled(GeyserSession session) {
        return session.getErosionHandler().isActive();
    }

    @Override
    public void setGameRule(GeyserSession session, String name, Object value) {
        super.setGameRule(session, name, value);
        this.gameruleCache.put((Object)name, (Object)String.valueOf(value));
    }

    @Override
    public boolean getGameRuleBool(GeyserSession session, GameRule gameRule) {
        String value = (String)this.gameruleCache.get((Object)gameRule.getJavaID());
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return gameRule.getDefaultBooleanValue();
    }

    @Override
    public int getGameRuleInt(GeyserSession session, GameRule gameRule) {
        String value = (String)this.gameruleCache.get((Object)gameRule.getJavaID());
        if (value != null) {
            return Integer.parseInt(value);
        }
        return gameRule.getDefaultIntValue();
    }

    @Override
    public GameMode getDefaultGameMode(GeyserSession session) {
        return GameMode.SURVIVAL;
    }

    @Override
    public boolean hasPermission(GeyserSession session, String permission) {
        return false;
    }

    @Override
    public @NonNull CompletableFuture<@Nullable CompoundTag> getPickItemNbt(GeyserSession session, int x, int y, int z, boolean addNbtData) {
        GeyserboundPacketHandlerImpl erosionHandler = session.getErosionHandler().getAsActive();
        if (erosionHandler == null) {
            return super.getPickItemNbt(session, x, y, z, addNbtData);
        }
        CompletableFuture<CompoundTag> future = new CompletableFuture<CompoundTag>();
        erosionHandler.setPickBlockLookup(future);
        erosionHandler.sendPacket(new BackendboundPickBlockPacket(Vector3i.from(x, y, z)));
        return future;
    }
}

