/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class WritableBookItem
extends Item {
    public WritableBookItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        ListTag pagesTag = (ListTag)tag.remove("pages");
        if (pagesTag == null) {
            return;
        }
        ArrayList<Tag> pages = new ArrayList<Tag>();
        Iterator iterator = pagesTag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag subTag = (Tag)iterator.next();
            if (!(subTag instanceof StringTag)) continue;
            StringTag textTag = (StringTag)subTag;
            CompoundTag pageTag = new CompoundTag("");
            pageTag.put(new StringTag("photoname", ""));
            pageTag.put(new StringTag("text", MessageTranslator.convertMessageLenient(textTag.getValue())));
            pages.add(pageTag);
        }
        tag.put(new ListTag("pages", pages));
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(tag, mapping);
        if (!tag.contains("pages")) {
            return;
        }
        ArrayList<Tag> pages = new ArrayList<Tag>();
        ListTag pagesTag = (ListTag)tag.get("pages");
        Iterator iterator = pagesTag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag subTag = (Tag)iterator.next();
            if (!(subTag instanceof CompoundTag)) continue;
            CompoundTag pageTag = (CompoundTag)subTag;
            StringTag textTag = (StringTag)pageTag.get("text");
            pages.add(new StringTag("", textTag.getValue()));
        }
        tag.remove("pages");
        tag.put(new ListTag("pages", pages));
    }
}

