/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.TippedArrowPotion;
import org.geysermc.geyser.item.type.ArrowItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

public class TippedArrowItem
extends ArrowItem {
    public TippedArrowItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        Object potionTag = itemStack.getNbt().get("Potion");
        if (potionTag instanceof StringTag) {
            TippedArrowPotion tippedArrowPotion = TippedArrowPotion.getByJavaIdentifier(((StringTag)potionTag).getValue());
            if (tippedArrowPotion != null) {
                return ItemData.builder().definition(mapping.getBedrockDefinition()).damage(tippedArrowPotion.getBedrockId()).count(itemStack.getAmount()).tag(ItemTranslator.translateNbtToBedrock(itemStack.getNbt()));
            }
            GeyserImpl.getInstance().getLogger().debug("Unknown Java potion (tipped arrow): " + ((Tag)potionTag).getValue());
        }
        return super.translateToBedrock(itemStack, mapping, mappings);
    }
}

