/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;

public class MapItem
extends Item {
    public MapItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        Object object;
        super.translateNbtToBedrock(session, tag);
        Object mapId = tag.remove("map");
        if (mapId == null || !((object = ((Tag)mapId).getValue()) instanceof Number)) {
            return;
        }
        Number number = (Number)object;
        int mapValue = number.intValue();
        tag.put(new LongTag("map_uuid", mapValue));
        tag.put(new IntTag("map_name_index", mapValue));
        tag.put(new ByteTag("map_display_players", 1));
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(tag, mapping);
        IntTag mapNameIndex = (IntTag)tag.remove("map_name_index");
        if (mapNameIndex != null) {
            tag.put(new IntTag("map", mapNameIndex.getValue()));
            tag.remove("map_uuid");
        }
    }
}

