/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;

public class EnchantedBookItem
extends Item {
    public EnchantedBookItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        ArrayList<Tag> newTags = new ArrayList<Tag>();
        Object enchantmentTag = tag.remove("StoredEnchantments");
        if (enchantmentTag instanceof ListTag) {
            ListTag listTag = (ListTag)enchantmentTag;
            Iterator iterator = listTag.getValue().iterator();
            while (iterator.hasNext()) {
                CompoundTag bedrockTag;
                Tag subTag = (Tag)iterator.next();
                if (!(subTag instanceof CompoundTag) || (bedrockTag = this.remapEnchantment(session, (CompoundTag)subTag, tag)) == null) continue;
                newTags.add(bedrockTag);
            }
        }
        if (!newTags.isEmpty()) {
            tag.put(new ListTag("ench", newTags));
        }
    }
}

