/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;

public class CompassItem
extends Item {
    public CompassItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        if (this.isLodestoneCompass(itemStack.getNbt())) {
            return super.translateToBedrock(itemStack, mappings.getLodestoneCompass(), mappings);
        }
        return super.translateToBedrock(itemStack, mapping, mappings);
    }

    @Override
    public ItemMapping toBedrockDefinition(CompoundTag nbt, ItemMappings mappings) {
        if (this.isLodestoneCompass(nbt)) {
            return mappings.getLodestoneCompass();
        }
        return super.toBedrockDefinition(nbt, mappings);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        Object lodestoneTag = tag.get("LodestoneTracked");
        if (lodestoneTag instanceof ByteTag) {
            int trackId = session.getLodestoneCache().store(tag);
            tag.put(new IntTag("trackingHandle", trackId));
        }
    }

    private boolean isLodestoneCompass(CompoundTag nbt) {
        if (nbt != null) {
            Object lodestoneTag = nbt.get("LodestoneTracked");
            return lodestoneTag instanceof ByteTag;
        }
        return false;
    }

    @Override
    public @NonNull ItemStack translateToJava(@NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        if (mapping.getBedrockIdentifier().equals("minecraft:lodestone_compass")) {
            mapping = mappings.getStoredItems().compass();
        }
        return super.translateToJava(itemData, mapping, mappings);
    }
}

