/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.components;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;

public enum ToolTier {
    WOODEN(2, () -> Set.of(Items.OAK_PLANKS, Items.SPRUCE_PLANKS, Items.BIRCH_PLANKS, Items.JUNGLE_PLANKS, Items.ACACIA_PLANKS, Items.DARK_OAK_PLANKS, Items.CRIMSON_PLANKS, Items.WARPED_PLANKS, Items.MANGROVE_PLANKS)),
    STONE(4, () -> Set.of(Items.COBBLESTONE, Items.BLACKSTONE, Items.COBBLED_DEEPSLATE)),
    IRON(6, () -> Collections.singleton(Items.IRON_INGOT)),
    GOLDEN(12, () -> Collections.singleton(Items.GOLD_INGOT)),
    DIAMOND(8, () -> Collections.singleton(Items.DIAMOND)),
    NETHERITE(9, () -> Collections.singleton(Items.NETHERITE_INGOT));

    private static final ToolTier[] VALUES;
    private final int speed;
    private final Supplier<Set<Item>> repairIngredients;

    private ToolTier(int speed, Supplier<Set<Item>> repairIngredients) {
        this.speed = speed;
        this.repairIngredients = Suppliers.memoize(repairIngredients::get);
    }

    public int getSpeed() {
        return this.speed;
    }

    public Set<Item> getRepairIngredients() {
        return this.repairIngredients.get();
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        VALUES = ToolTier.values();
    }
}

