/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import java.util.Comparator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class ExtensionsCommand
extends GeyserCommand {
    private final GeyserImpl geyser;

    public ExtensionsCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission);
        this.geyser = geyser;
    }

    @Override
    public void execute(@Nullable GeyserSession session, GeyserCommandSource sender, String[] args) {
        int page = 1;
        int maxPage = 1;
        String header = GeyserLocale.getPlayerLocaleString("geyser.commands.extensions.header", sender.locale(), page, maxPage);
        sender.sendMessage(header);
        this.geyser.extensionManager().extensions().stream().sorted(Comparator.comparing(Extension::name)).forEach(extension -> {
            String extensionName = (extension.isEnabled() ? "\u00a7a" : "\u00a7c") + extension.name();
            sender.sendMessage("- " + extensionName + "\u00a7r v" + extension.description().version() + this.formatAuthors(extension.description().authors()));
        });
    }

    private String formatAuthors(List<String> authors) {
        return authors.isEmpty() ? "" : " by: " + String.join((CharSequence)", ", authors);
    }
}

