/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.command.CommandExecutor;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.command.defaults.AdvancedTooltipsCommand;
import org.geysermc.geyser.command.defaults.AdvancementsCommand;
import org.geysermc.geyser.command.defaults.ConnectionTestCommand;
import org.geysermc.geyser.command.defaults.DumpCommand;
import org.geysermc.geyser.command.defaults.ExtensionsCommand;
import org.geysermc.geyser.command.defaults.HelpCommand;
import org.geysermc.geyser.command.defaults.ListCommand;
import org.geysermc.geyser.command.defaults.OffhandCommand;
import org.geysermc.geyser.command.defaults.ReloadCommand;
import org.geysermc.geyser.command.defaults.SettingsCommand;
import org.geysermc.geyser.command.defaults.StatisticsCommand;
import org.geysermc.geyser.command.defaults.StopCommand;
import org.geysermc.geyser.command.defaults.VersionCommand;
import org.geysermc.geyser.event.type.GeyserDefineCommandsEventImpl;
import org.geysermc.geyser.extension.command.GeyserExtensionCommand;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class GeyserCommandManager {
    private final Map<String, Command> commands = new Object2ObjectOpenHashMap(12);
    private final Map<Extension, Map<String, Command>> extensionCommands = new Object2ObjectOpenHashMap(0);
    private final GeyserImpl geyser;

    public void init() {
        this.registerBuiltInCommand(new HelpCommand(this.geyser, "help", "geyser.commands.help.desc", "geyser.command.help", "geyser", this.commands));
        this.registerBuiltInCommand(new ListCommand(this.geyser, "list", "geyser.commands.list.desc", "geyser.command.list"));
        this.registerBuiltInCommand(new ReloadCommand(this.geyser, "reload", "geyser.commands.reload.desc", "geyser.command.reload"));
        this.registerBuiltInCommand(new OffhandCommand(this.geyser, "offhand", "geyser.commands.offhand.desc", "geyser.command.offhand"));
        this.registerBuiltInCommand(new DumpCommand(this.geyser, "dump", "geyser.commands.dump.desc", "geyser.command.dump"));
        this.registerBuiltInCommand(new VersionCommand(this.geyser, "version", "geyser.commands.version.desc", "geyser.command.version"));
        this.registerBuiltInCommand(new SettingsCommand(this.geyser, "settings", "geyser.commands.settings.desc", "geyser.command.settings"));
        this.registerBuiltInCommand(new StatisticsCommand(this.geyser, "statistics", "geyser.commands.statistics.desc", "geyser.command.statistics"));
        this.registerBuiltInCommand(new AdvancementsCommand("advancements", "geyser.commands.advancements.desc", "geyser.command.advancements"));
        this.registerBuiltInCommand(new AdvancedTooltipsCommand("tooltips", "geyser.commands.advancedtooltips.desc", "geyser.command.tooltips"));
        this.registerBuiltInCommand(new ConnectionTestCommand(this.geyser, "connectiontest", "geyser.commands.connectiontest.desc", "geyser.command.connectiontest"));
        if (this.geyser.getPlatformType() == PlatformType.STANDALONE) {
            this.registerBuiltInCommand(new StopCommand(this.geyser, "stop", "geyser.commands.stop.desc", "geyser.command.stop"));
        }
        if (this.geyser.extensionManager().extensions().size() > 0) {
            this.registerBuiltInCommand(new ExtensionsCommand(this.geyser, "extensions", "geyser.commands.extensions.desc", "geyser.command.extensions"));
        }
        GeyserDefineCommandsEventImpl defineCommandsEvent = new GeyserDefineCommandsEventImpl(this.commands){

            @Override
            public void register(@NonNull Command command) {
                if (!(command instanceof GeyserExtensionCommand)) {
                    throw new IllegalArgumentException("Expected GeyserExtensionCommand as part of command registration but got " + command + "! Did you use the Command builder properly?");
                }
                GeyserExtensionCommand extensionCommand = (GeyserExtensionCommand)command;
                GeyserCommandManager.this.registerExtensionCommand(extensionCommand.extension(), extensionCommand);
            }
        };
        this.geyser.eventBus().fire(defineCommandsEvent);
        for (Map.Entry<Extension, Map<String, Command>> entry : this.extensionCommands.entrySet()) {
            String id = entry.getKey().description().id();
            this.registerExtensionCommand(entry.getKey(), new HelpCommand(this.geyser, "help", "geyser.commands.exthelp.desc", "geyser.command.exthelp." + id, id, entry.getValue()));
        }
    }

    public void registerBuiltInCommand(GeyserCommand command) {
        this.register(command, this.commands);
    }

    public void registerExtensionCommand(@NonNull Extension extension, @NonNull Command command) {
        this.register(command, this.extensionCommands.computeIfAbsent(extension, e -> new HashMap()));
    }

    private void register(Command command, Map<String, Command> commands) {
        commands.put(command.name(), command);
        this.geyser.getLogger().debug(GeyserLocale.getLocaleStringLog("geyser.commands.registered", command.name()));
        if (command.aliases().isEmpty()) {
            return;
        }
        for (String alias : command.aliases()) {
            commands.put(alias, command);
        }
    }

    public @NonNull Map<String, Command> commands() {
        return Collections.unmodifiableMap(this.commands);
    }

    public @NonNull Map<Extension, Map<String, Command>> extensionCommands() {
        return Collections.unmodifiableMap(this.extensionCommands);
    }

    public boolean runCommand(GeyserCommandSource sender, String command) {
        String[] args;
        String label;
        Extension extension = null;
        for (Extension loopedExtension : this.extensionCommands.keySet()) {
            if (!command.startsWith(loopedExtension.description().id() + " ")) continue;
            extension = loopedExtension;
            break;
        }
        if (!command.startsWith("geyser ") && extension == null) {
            return false;
        }
        if (!(command = command.trim().replace((CharSequence)(extension != null ? extension.description().id() + " " : "geyser "), "")).contains(" ")) {
            label = command.toLowerCase(Locale.ROOT);
            args = new String[]{};
        } else {
            String[] stringArray;
            label = command.substring(0, command.indexOf(" ")).toLowerCase(Locale.ROOT);
            String argLine = command.substring(command.indexOf(" ") + 1);
            if (argLine.contains(" ")) {
                stringArray = argLine.split(" ");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = argLine;
            }
            args = stringArray;
        }
        Command cmd = (extension != null ? this.extensionCommands.getOrDefault(extension, Collections.emptyMap()) : this.commands).get(label);
        if (cmd == null) {
            sender.sendMessage(GeyserLocale.getLocaleStringLog("geyser.commands.invalid"));
            return false;
        }
        if (cmd instanceof GeyserCommand) {
            if (sender instanceof GeyserSession) {
                ((GeyserCommand)cmd).execute((GeyserSession)sender, sender, args);
            } else if (!cmd.isBedrockOnly()) {
                ((GeyserCommand)cmd).execute(null, sender, args);
            } else {
                this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.command.bedrock_only"));
            }
        }
        return true;
    }

    public String description(String command) {
        return "";
    }

    public GeyserCommandManager(GeyserImpl geyser) {
        this.geyser = geyser;
    }

    public Map<String, Command> getCommands() {
        return this.commands;
    }

    public static class CommandBuilder<T extends CommandSource>
    implements Command.Builder<T> {
        private final Extension extension;
        private Class<? extends T> sourceType;
        private String name;
        private String description = "";
        private String permission = "";
        private List<String> aliases;
        private boolean suggestedOpOnly = false;
        private boolean executableOnConsole = true;
        private List<String> subCommands;
        private boolean bedrockOnly;
        private CommandExecutor<T> executor;

        @Override
        public Command.Builder<T> source(@NonNull Class<? extends T> sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public CommandBuilder<T> name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @Override
        public CommandBuilder<T> description(@NonNull String description) {
            this.description = description;
            return this;
        }

        @Override
        public CommandBuilder<T> permission(@NonNull String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public CommandBuilder<T> aliases(@NonNull List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        @Override
        public Command.Builder<T> suggestedOpOnly(boolean suggestedOpOnly) {
            this.suggestedOpOnly = suggestedOpOnly;
            return this;
        }

        @Override
        public CommandBuilder<T> executableOnConsole(boolean executableOnConsole) {
            this.executableOnConsole = executableOnConsole;
            return this;
        }

        @Override
        public CommandBuilder<T> subCommands(@NonNull List<String> subCommands) {
            this.subCommands = subCommands;
            return this;
        }

        @Override
        public CommandBuilder<T> bedrockOnly(boolean bedrockOnly) {
            this.bedrockOnly = bedrockOnly;
            return this;
        }

        @Override
        public CommandBuilder<T> executor(@NonNull CommandExecutor<T> executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public @NonNull GeyserExtensionCommand build() {
            if (this.name == null || this.name.isBlank()) {
                throw new IllegalArgumentException("Command cannot be null or blank!");
            }
            if (this.sourceType == null) {
                throw new IllegalArgumentException("Source type was not defined for command " + this.name + " in extension " + this.extension.name());
            }
            return new GeyserExtensionCommand(this.extension, this.name, this.description, this.permission){

                @Override
                public void execute(@Nullable GeyserSession session, GeyserCommandSource sender, String[] args) {
                    Class sourceType = sourceType;
                    CommandExecutor<GeyserCommandSource> executor = executor;
                    if (sourceType.isInstance(session)) {
                        executor.execute(session, this, args);
                        return;
                    }
                    if (sourceType.isInstance(sender)) {
                        executor.execute(sender, this, args);
                        return;
                    }
                    GeyserImpl.getInstance().getLogger().debug("Ignoring command " + this.name + " due to no suitable sender.");
                }

                @Override
                public @NonNull List<String> aliases() {
                    return aliases == null ? Collections.emptyList() : aliases;
                }

                @Override
                public boolean isSuggestedOpOnly() {
                    return suggestedOpOnly;
                }

                @Override
                public @NonNull List<String> subCommands() {
                    return subCommands == null ? Collections.emptyList() : subCommands;
                }

                @Override
                public boolean isBedrockOnly() {
                    return bedrockOnly;
                }

                @Override
                public boolean isExecutableOnConsole() {
                    return executableOnConsole;
                }
            };
        }

        public CommandBuilder(Extension extension) {
            this.extension = extension;
        }
    }
}

