/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserCommandExecutor {
    protected final GeyserImpl geyser;
    private final Map<String, Command> commands;

    public GeyserCommand getCommand(String label) {
        return (GeyserCommand)this.commands.get(label);
    }

    public @Nullable GeyserSession getGeyserSession(GeyserCommandSource sender) {
        if (sender.isConsole()) {
            return null;
        }
        for (GeyserSession session : this.geyser.getSessionManager().getSessions().values()) {
            if (!sender.name().equals(session.getPlayerEntity().getUsername())) continue;
            return session;
        }
        return null;
    }

    public List<String> tabComplete(GeyserCommandSource sender) {
        if (this.getGeyserSession(sender) != null) {
            return Collections.emptyList();
        }
        ArrayList<String> availableCommands = new ArrayList<String>();
        for (Map.Entry<String, Command> entry : this.commands.entrySet()) {
            Command geyserCommand = entry.getValue();
            if (!sender.hasPermission(geyserCommand.permission()) || geyserCommand.isBedrockOnly()) continue;
            availableCommands.add(entry.getKey());
        }
        return availableCommands;
    }

    public GeyserCommandExecutor(GeyserImpl geyser, Map<String, Command> commands) {
        this.geyser = geyser;
        this.commands = commands;
    }
}

