/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.channel.raknet;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cloudburstmc.netty.channel.proxy.ProxyChannel;
import org.cloudburstmc.netty.channel.raknet.RakChildChannel;
import org.cloudburstmc.netty.channel.raknet.config.DefaultRakServerConfig;
import org.cloudburstmc.netty.channel.raknet.config.RakServerChannelConfig;
import org.cloudburstmc.netty.handler.codec.raknet.common.UnconnectedPongEncoder;
import org.cloudburstmc.netty.handler.codec.raknet.server.RakServerOfflineHandler;
import org.cloudburstmc.netty.handler.codec.raknet.server.RakServerRouteHandler;
import org.cloudburstmc.netty.handler.codec.raknet.server.RakServerTailHandler;

public class RakServerChannel
extends ProxyChannel<DatagramChannel>
implements ServerChannel {
    private final RakServerChannelConfig config;
    private final Map<SocketAddress, RakChildChannel> childChannelMap = new ConcurrentHashMap<SocketAddress, RakChildChannel>();

    public RakServerChannel(DatagramChannel channel) {
        super(channel);
        this.config = new DefaultRakServerConfig(this);
        this.pipeline.addLast("rak-unconnected-pong-encoder", (ChannelHandler)UnconnectedPongEncoder.INSTANCE);
        this.pipeline.addLast("rak-offline-handler", (ChannelHandler)new RakServerOfflineHandler());
        this.pipeline().addLast("rak-server-route-handler", (ChannelHandler)new RakServerRouteHandler(this));
        this.pipeline().addLast("rak-server-tail-handler", (ChannelHandler)RakServerTailHandler.INSTANCE);
    }

    public RakChildChannel createChildChannel(InetSocketAddress address, long clientGuid, int protocolVersion, int mtu) {
        if (this.childChannelMap.containsKey(address)) {
            return null;
        }
        RakChildChannel channel = new RakChildChannel(address, this, clientGuid, protocolVersion, mtu);
        channel.closeFuture().addListener(this::onChildClosed);
        this.pipeline().fireChannelRead((Object)channel).fireChannelReadComplete();
        this.childChannelMap.put(address, channel);
        return channel;
    }

    public RakChildChannel getChildChannel(SocketAddress address) {
        return this.childChannelMap.get(address);
    }

    private void onChildClosed(ChannelFuture channelFuture) {
        RakChildChannel channel = (RakChildChannel)channelFuture.channel();
        channel.rakPipeline().fireChannelInactive();
        channel.rakPipeline().fireChannelUnregistered();
        this.childChannelMap.remove(channel.remoteAddress());
    }

    @Override
    public void onCloseTriggered(ChannelPromise promise) {
        PromiseCombiner combiner = new PromiseCombiner((EventExecutor)this.eventLoop());
        this.childChannelMap.values().forEach(channel -> combiner.add((Future)channel.close()));
        ChannelPromise combinedPromise = this.newPromise();
        combinedPromise.addListener(future -> super.onCloseTriggered(promise));
        combiner.finish((Promise)combinedPromise);
    }

    @Override
    public RakServerChannelConfig config() {
        return this.config;
    }
}

