/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.channel.raknet;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.function.Consumer;
import org.cloudburstmc.netty.channel.raknet.RakClientChannel;
import org.cloudburstmc.netty.channel.raknet.RakServerChannel;

public class RakChannelFactory<T extends Channel>
implements ChannelFactory<T> {
    private final Constructor<? extends T> constructor;
    private final Constructor<? extends DatagramChannel> datagramConstructor;
    private final Consumer<DatagramChannel> parentConsumer;

    private RakChannelFactory(Class<? extends T> clazz, Class<? extends DatagramChannel> datagramClass, Consumer<DatagramChannel> parentConsumer) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(datagramClass, "datagramClass");
        try {
            this.constructor = clazz.getConstructor(DatagramChannel.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Proxy class " + StringUtil.simpleClassName(clazz) + " does not have a public non-arg constructor", e);
        }
        try {
            this.datagramConstructor = datagramClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + StringUtil.simpleClassName(clazz) + " does not have a public non-arg constructor", e);
        }
        this.parentConsumer = parentConsumer;
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz) {
        return new RakChannelFactory<RakServerChannel>(RakServerChannel.class, clazz, null);
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz, Consumer<DatagramChannel> parentConsumer) {
        return new RakChannelFactory<RakServerChannel>(RakServerChannel.class, clazz, parentConsumer);
    }

    public static RakChannelFactory<RakClientChannel> client(Class<? extends DatagramChannel> clazz) {
        return new RakChannelFactory<RakClientChannel>(RakClientChannel.class, clazz, null);
    }

    public static RakChannelFactory<RakClientChannel> client(Class<? extends DatagramChannel> clazz, Consumer<DatagramChannel> parentConsumer) {
        return new RakChannelFactory<RakClientChannel>(RakClientChannel.class, clazz, parentConsumer);
    }

    public T newChannel() {
        try {
            DatagramChannel channel = this.datagramConstructor.newInstance(new Object[0]);
            if (this.parentConsumer != null) {
                this.parentConsumer.accept(channel);
            }
            return (T)((Channel)this.constructor.newInstance(channel));
        }
        catch (Throwable t) {
            throw new ChannelException("Unable to create Channel from class " + this.constructor.getDeclaringClass(), t);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(RakChannelFactory.class) + '(' + StringUtil.simpleClassName(this.constructor.getDeclaringClass()) + ".class, " + StringUtil.simpleClassName(this.datagramConstructor.getDeclaringClass()) + ".class)";
    }
}

