/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.blockstateupdater.util;

public class OrderedUpdater {
    public static final OrderedUpdater FACING_TO_BLOCK = new OrderedUpdater("facing_direction", "minecraft:block_face", "down", "up", "north", "south", "west", "east");
    public static final OrderedUpdater FACING_TO_CARDINAL = new OrderedUpdater("facing_direction", "minecraft:cardinal_direction", 2, "north", "south", "west", "east");
    public static final OrderedUpdater DIRECTION_TO_CARDINAL = new OrderedUpdater("direction", "minecraft:cardinal_direction", "south", "west", "north", "east");
    private final String oldProperty;
    private final String newProperty;
    private final String[] order;
    private final int offset;

    public OrderedUpdater(String oldProperty, String newProperty, String ... order) {
        this(oldProperty, newProperty, 0, order);
    }

    public OrderedUpdater(String oldProperty, String newProperty, int offset, String ... order) {
        if (order.length < 1) {
            throw new IllegalArgumentException("empty order array");
        }
        this.oldProperty = oldProperty;
        this.newProperty = newProperty;
        this.offset = offset;
        this.order = order;
    }

    public String translate(int value) {
        int index = value - this.offset;
        if (index < 0 || index >= this.order.length) {
            index = 0;
        }
        return this.order[index];
    }

    public String getOldProperty() {
        return this.oldProperty;
    }

    public String getNewProperty() {
        return this.newProperty;
    }
}

