/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class ServerboundCustomQueryAnswerPacket
implements MinecraftPacket {
    private final int transactionId;
    private final byte @Nullable [] data;

    public ServerboundCustomQueryAnswerPacket(int transactionId) {
        this(transactionId, new byte[0]);
    }

    public ServerboundCustomQueryAnswerPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.transactionId = helper.readVarInt(in);
        this.data = helper.readNullable(in, buf -> helper.readByteArray((ByteBuf)buf, ByteBuf::readableBytes));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.transactionId);
        helper.writeNullable(out, this.data, ByteBuf::writeBytes);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public byte @Nullable [] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundCustomQueryAnswerPacket)) {
            return false;
        }
        ServerboundCustomQueryAnswerPacket other = (ServerboundCustomQueryAnswerPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundCustomQueryAnswerPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "ServerboundCustomQueryAnswerPacket(transactionId=" + this.getTransactionId() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public ServerboundCustomQueryAnswerPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerboundCustomQueryAnswerPacket(transactionId, this.data);
    }

    public ServerboundCustomQueryAnswerPacket withData(byte @Nullable [] data) {
        return this.data == data ? this : new ServerboundCustomQueryAnswerPacket(this.transactionId, data);
    }

    public ServerboundCustomQueryAnswerPacket(int transactionId, byte @Nullable [] data) {
        this.transactionId = transactionId;
        this.data = data;
    }
}

