/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundUseItemPacket
implements MinecraftPacket {
    @NonNull
    private final Hand hand;
    private final int sequence;

    public ServerboundUseItemPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.hand = Hand.from(helper.readVarInt(in));
        this.sequence = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.hand.ordinal());
        helper.writeVarInt(out, this.sequence);
    }

    @NonNull
    public Hand getHand() {
        return this.hand;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundUseItemPacket)) {
            return false;
        }
        ServerboundUseItemPacket other = (ServerboundUseItemPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundUseItemPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundUseItemPacket(hand=" + this.getHand() + ", sequence=" + this.getSequence() + ")";
    }

    public ServerboundUseItemPacket withHand(@NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        return this.hand == hand ? this : new ServerboundUseItemPacket(hand, this.sequence);
    }

    public ServerboundUseItemPacket withSequence(int sequence) {
        return this.sequence == sequence ? this : new ServerboundUseItemPacket(this.hand, sequence);
    }

    public ServerboundUseItemPacket(@NonNull Hand hand, int sequence) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        this.hand = hand;
        this.sequence = sequence;
    }
}

