/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundSetCreativeModeSlotPacket
implements MinecraftPacket {
    private final int slot;
    @NonNull
    private final ItemStack clickedItem;

    public ServerboundSetCreativeModeSlotPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.slot = in.readShort();
        this.clickedItem = helper.readItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeShort(this.slot);
        helper.writeItemStack(out, this.clickedItem);
    }

    public int getSlot() {
        return this.slot;
    }

    @NonNull
    public ItemStack getClickedItem() {
        return this.clickedItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetCreativeModeSlotPacket)) {
            return false;
        }
        ServerboundSetCreativeModeSlotPacket other = (ServerboundSetCreativeModeSlotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ItemStack this$clickedItem = this.getClickedItem();
        ItemStack other$clickedItem = other.getClickedItem();
        return !(this$clickedItem == null ? other$clickedItem != null : !((Object)this$clickedItem).equals(other$clickedItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundSetCreativeModeSlotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        ItemStack $clickedItem = this.getClickedItem();
        result = result * 59 + ($clickedItem == null ? 43 : ((Object)$clickedItem).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundSetCreativeModeSlotPacket(slot=" + this.getSlot() + ", clickedItem=" + this.getClickedItem() + ")";
    }

    public ServerboundSetCreativeModeSlotPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundSetCreativeModeSlotPacket(slot, this.clickedItem);
    }

    public ServerboundSetCreativeModeSlotPacket withClickedItem(@NonNull ItemStack clickedItem) {
        if (clickedItem == null) {
            throw new NullPointerException("clickedItem is marked non-null but is null");
        }
        return this.clickedItem == clickedItem ? this : new ServerboundSetCreativeModeSlotPacket(this.slot, clickedItem);
    }

    public ServerboundSetCreativeModeSlotPacket(int slot, @NonNull ItemStack clickedItem) {
        if (clickedItem == null) {
            throw new NullPointerException("clickedItem is marked non-null but is null");
        }
        this.slot = slot;
        this.clickedItem = clickedItem;
    }
}

