/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.border;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundInitializeBorderPacket
implements MinecraftPacket {
    private final double newCenterX;
    private final double newCenterZ;
    private final double oldSize;
    private final double newSize;
    private final long lerpTime;
    private final int newAbsoluteMaxSize;
    private final int warningBlocks;
    private final int warningTime;

    public ClientboundInitializeBorderPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.newCenterX = in.readDouble();
        this.newCenterZ = in.readDouble();
        this.oldSize = in.readDouble();
        this.newSize = in.readDouble();
        this.lerpTime = helper.readVarLong(in);
        this.newAbsoluteMaxSize = helper.readVarInt(in);
        this.warningBlocks = helper.readVarInt(in);
        this.warningTime = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeDouble(this.newCenterX);
        out.writeDouble(this.newCenterZ);
        out.writeDouble(this.oldSize);
        out.writeDouble(this.newSize);
        helper.writeVarLong(out, this.lerpTime);
        helper.writeVarInt(out, this.newAbsoluteMaxSize);
        helper.writeVarInt(out, this.warningBlocks);
        helper.writeVarInt(out, this.warningTime);
    }

    public double getNewCenterX() {
        return this.newCenterX;
    }

    public double getNewCenterZ() {
        return this.newCenterZ;
    }

    public double getOldSize() {
        return this.oldSize;
    }

    public double getNewSize() {
        return this.newSize;
    }

    public long getLerpTime() {
        return this.lerpTime;
    }

    public int getNewAbsoluteMaxSize() {
        return this.newAbsoluteMaxSize;
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundInitializeBorderPacket)) {
            return false;
        }
        ClientboundInitializeBorderPacket other = (ClientboundInitializeBorderPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getNewCenterX(), other.getNewCenterX()) != 0) {
            return false;
        }
        if (Double.compare(this.getNewCenterZ(), other.getNewCenterZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getOldSize(), other.getOldSize()) != 0) {
            return false;
        }
        if (Double.compare(this.getNewSize(), other.getNewSize()) != 0) {
            return false;
        }
        if (this.getLerpTime() != other.getLerpTime()) {
            return false;
        }
        if (this.getNewAbsoluteMaxSize() != other.getNewAbsoluteMaxSize()) {
            return false;
        }
        if (this.getWarningBlocks() != other.getWarningBlocks()) {
            return false;
        }
        return this.getWarningTime() == other.getWarningTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundInitializeBorderPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $newCenterX = Double.doubleToLongBits(this.getNewCenterX());
        result = result * 59 + (int)($newCenterX >>> 32 ^ $newCenterX);
        long $newCenterZ = Double.doubleToLongBits(this.getNewCenterZ());
        result = result * 59 + (int)($newCenterZ >>> 32 ^ $newCenterZ);
        long $oldSize = Double.doubleToLongBits(this.getOldSize());
        result = result * 59 + (int)($oldSize >>> 32 ^ $oldSize);
        long $newSize = Double.doubleToLongBits(this.getNewSize());
        result = result * 59 + (int)($newSize >>> 32 ^ $newSize);
        long $lerpTime = this.getLerpTime();
        result = result * 59 + (int)($lerpTime >>> 32 ^ $lerpTime);
        result = result * 59 + this.getNewAbsoluteMaxSize();
        result = result * 59 + this.getWarningBlocks();
        result = result * 59 + this.getWarningTime();
        return result;
    }

    public String toString() {
        return "ClientboundInitializeBorderPacket(newCenterX=" + this.getNewCenterX() + ", newCenterZ=" + this.getNewCenterZ() + ", oldSize=" + this.getOldSize() + ", newSize=" + this.getNewSize() + ", lerpTime=" + this.getLerpTime() + ", newAbsoluteMaxSize=" + this.getNewAbsoluteMaxSize() + ", warningBlocks=" + this.getWarningBlocks() + ", warningTime=" + this.getWarningTime() + ")";
    }

    public ClientboundInitializeBorderPacket withNewCenterX(double newCenterX) {
        return this.newCenterX == newCenterX ? this : new ClientboundInitializeBorderPacket(newCenterX, this.newCenterZ, this.oldSize, this.newSize, this.lerpTime, this.newAbsoluteMaxSize, this.warningBlocks, this.warningTime);
    }

    public ClientboundInitializeBorderPacket withNewCenterZ(double newCenterZ) {
        return this.newCenterZ == newCenterZ ? this : new ClientboundInitializeBorderPacket(this.newCenterX, newCenterZ, this.oldSize, this.newSize, this.lerpTime, this.newAbsoluteMaxSize, this.warningBlocks, this.warningTime);
    }

    public ClientboundInitializeBorderPacket withOldSize(double oldSize) {
        return this.oldSize == oldSize ? this : new ClientboundInitializeBorderPacket(this.newCenterX, this.newCenterZ, oldSize, this.newSize, this.lerpTime, this.newAbsoluteMaxSize, this.warningBlocks, this.warningTime);
    }

    public ClientboundInitializeBorderPacket withNewSize(double newSize) {
        return this.newSize == newSize ? this : new ClientboundInitializeBorderPacket(this.newCenterX, this.newCenterZ, this.oldSize, newSize, this.lerpTime, this.newAbsoluteMaxSize, this.warningBlocks, this.warningTime);
    }

    public ClientboundInitializeBorderPacket withLerpTime(long lerpTime) {
        return this.lerpTime == lerpTime ? this : new ClientboundInitializeBorderPacket(this.newCenterX, this.newCenterZ, this.oldSize, this.newSize, lerpTime, this.newAbsoluteMaxSize, this.warningBlocks, this.warningTime);
    }

    public ClientboundInitializeBorderPacket withNewAbsoluteMaxSize(int newAbsoluteMaxSize) {
        return this.newAbsoluteMaxSize == newAbsoluteMaxSize ? this : new ClientboundInitializeBorderPacket(this.newCenterX, this.newCenterZ, this.oldSize, this.newSize, this.lerpTime, newAbsoluteMaxSize, this.warningBlocks, this.warningTime);
    }

    public ClientboundInitializeBorderPacket withWarningBlocks(int warningBlocks) {
        return this.warningBlocks == warningBlocks ? this : new ClientboundInitializeBorderPacket(this.newCenterX, this.newCenterZ, this.oldSize, this.newSize, this.lerpTime, this.newAbsoluteMaxSize, warningBlocks, this.warningTime);
    }

    public ClientboundInitializeBorderPacket withWarningTime(int warningTime) {
        return this.warningTime == warningTime ? this : new ClientboundInitializeBorderPacket(this.newCenterX, this.newCenterZ, this.oldSize, this.newSize, this.lerpTime, this.newAbsoluteMaxSize, this.warningBlocks, warningTime);
    }

    public ClientboundInitializeBorderPacket(double newCenterX, double newCenterZ, double oldSize, double newSize, long lerpTime, int newAbsoluteMaxSize, int warningBlocks, int warningTime) {
        this.newCenterX = newCenterX;
        this.newCenterZ = newCenterZ;
        this.oldSize = oldSize;
        this.newSize = newSize;
        this.lerpTime = lerpTime;
        this.newAbsoluteMaxSize = newAbsoluteMaxSize;
        this.warningBlocks = warningBlocks;
        this.warningTime = warningTime;
    }
}

