/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.player;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.GlobalPos;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSpawnInfo {
    @NonNull
    private final String dimension;
    @NonNull
    private final String worldName;
    private final long hashedSeed;
    @NonNull
    private final GameMode gameMode;
    @Nullable
    private final GameMode previousGamemode;
    private final boolean debug;
    private final boolean flat;
    @Nullable
    private final GlobalPos lastDeathPos;
    private final int portalCooldown;

    @NonNull
    public String getDimension() {
        return this.dimension;
    }

    @NonNull
    public String getWorldName() {
        return this.worldName;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    @NonNull
    public GameMode getGameMode() {
        return this.gameMode;
    }

    @Nullable
    public GameMode getPreviousGamemode() {
        return this.previousGamemode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    @Nullable
    public GlobalPos getLastDeathPos() {
        return this.lastDeathPos;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerSpawnInfo)) {
            return false;
        }
        PlayerSpawnInfo other = (PlayerSpawnInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHashedSeed() != other.getHashedSeed()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.getPortalCooldown() != other.getPortalCooldown()) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        GameMode this$gameMode = this.getGameMode();
        GameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
            return false;
        }
        GameMode this$previousGamemode = this.getPreviousGamemode();
        GameMode other$previousGamemode = other.getPreviousGamemode();
        if (this$previousGamemode == null ? other$previousGamemode != null : !this$previousGamemode.equals(other$previousGamemode)) {
            return false;
        }
        GlobalPos this$lastDeathPos = this.getLastDeathPos();
        GlobalPos other$lastDeathPos = other.getLastDeathPos();
        return !(this$lastDeathPos == null ? other$lastDeathPos != null : !this$lastDeathPos.equals(other$lastDeathPos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerSpawnInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $hashedSeed = this.getHashedSeed();
        result = result * 59 + (int)($hashedSeed >>> 32 ^ $hashedSeed);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + this.getPortalCooldown();
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        GameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
        GameMode $previousGamemode = this.getPreviousGamemode();
        result = result * 59 + ($previousGamemode == null ? 43 : $previousGamemode.hashCode());
        GlobalPos $lastDeathPos = this.getLastDeathPos();
        result = result * 59 + ($lastDeathPos == null ? 43 : $lastDeathPos.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerSpawnInfo(dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", hashedSeed=" + this.getHashedSeed() + ", gameMode=" + this.getGameMode() + ", previousGamemode=" + this.getPreviousGamemode() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", lastDeathPos=" + this.getLastDeathPos() + ", portalCooldown=" + this.getPortalCooldown() + ")";
    }

    public PlayerSpawnInfo(@NonNull String dimension, @NonNull String worldName, long hashedSeed, @NonNull GameMode gameMode, @Nullable GameMode previousGamemode, boolean debug, boolean flat, @Nullable GlobalPos lastDeathPos, int portalCooldown) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        if (gameMode == null) {
            throw new NullPointerException("gameMode is marked non-null but is null");
        }
        this.dimension = dimension;
        this.worldName = worldName;
        this.hashedSeed = hashedSeed;
        this.gameMode = gameMode;
        this.previousGamemode = previousGamemode;
        this.debug = debug;
        this.flat = flat;
        this.lastDeathPos = lastDeathPos;
        this.portalCooldown = portalCooldown;
    }
}

