/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.auth.data;

import com.github.steveice10.mc.auth.exception.property.ProfileTextureException;
import com.github.steveice10.mc.auth.exception.property.PropertyException;
import com.github.steveice10.mc.auth.exception.property.SignatureValidateException;
import com.github.steveice10.mc.auth.service.SessionService;
import com.github.steveice10.mc.auth.util.Base64;
import com.github.steveice10.mc.auth.util.UUIDSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class GameProfile {
    private static final String[] WHITELISTED_DOMAINS = new String[]{".minecraft.net", ".mojang.com"};
    private static final PublicKey SIGNATURE_KEY;
    private static final Gson GSON;
    private UUID id;
    private String name;
    private List<Property> properties;
    private Map<TextureType, Texture> textures;
    private boolean texturesVerified;

    private static boolean isWhitelistedDomain(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL \"" + url + "\".");
        }
        String domain = uri.getHost();
        for (String whitelistedDomain : WHITELISTED_DOMAINS) {
            if (!domain.endsWith(whitelistedDomain)) continue;
            return true;
        }
        return false;
    }

    public GameProfile(String id, String name) {
        this(id == null || id.equals("") ? null : UUID.fromString(id), name);
    }

    public GameProfile(UUID id, String name) {
        if (id == null && (name == null || name.equals(""))) {
            throw new IllegalArgumentException("Name and ID cannot both be blank");
        }
        this.id = id;
        this.name = name;
    }

    public boolean isComplete() {
        return this.id != null && this.name != null && !this.name.equals("");
    }

    public UUID getId() {
        return this.id;
    }

    public String getIdAsString() {
        return this.id != null ? this.id.toString() : "";
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        return Collections.unmodifiableList(this.properties);
    }

    public void setProperties(List<Property> properties) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        } else {
            this.properties.clear();
        }
        if (properties != null) {
            this.properties.addAll(properties);
        }
        this.textures = null;
        this.texturesVerified = false;
    }

    public Property getProperty(String name) {
        for (Property property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Map<TextureType, Texture> getTextures() throws PropertyException {
        return this.getTextures(true);
    }

    public Map<TextureType, Texture> getTextures(boolean requireSecure) throws PropertyException {
        if (this.textures == null || requireSecure && !this.texturesVerified) {
            Property textures = this.getProperty("textures");
            if (textures != null) {
                MinecraftTexturesPayload result;
                if (requireSecure) {
                    if (!textures.hasSignature()) {
                        throw new ProfileTextureException("Signature is missing from textures payload.");
                    }
                    if (!textures.isSignatureValid(SIGNATURE_KEY)) {
                        throw new ProfileTextureException("Textures payload has been tampered with. (signature invalid)");
                    }
                }
                try {
                    String json = new String(Base64.decode(textures.getValue().getBytes(StandardCharsets.UTF_8)));
                    result = (MinecraftTexturesPayload)GSON.fromJson(json, MinecraftTexturesPayload.class);
                }
                catch (Exception e) {
                    throw new ProfileTextureException("Could not decode texture payload.", e);
                }
                if (result != null && result.textures != null) {
                    if (requireSecure) {
                        for (Texture texture : result.textures.values()) {
                            if (GameProfile.isWhitelistedDomain(texture.getURL())) continue;
                            throw new ProfileTextureException("Textures payload has been tampered with. (non-whitelisted domain)");
                        }
                    }
                    this.textures = result.textures;
                } else {
                    this.textures = Collections.emptyMap();
                }
                this.texturesVerified = requireSecure;
            } else {
                return Collections.emptyMap();
            }
        }
        return Collections.unmodifiableMap(this.textures);
    }

    public Texture getTexture(TextureType type) throws PropertyException {
        return this.getTextures().get((Object)type);
    }

    public Texture getTexture(TextureType type, boolean requireSecure) throws PropertyException {
        return this.getTextures(requireSecure).get((Object)type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GameProfile that = (GameProfile)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GameProfile{id=" + this.id + ", name=" + this.name + ", properties=" + this.getProperties() + "}";
    }

    static {
        try (InputStream in = SessionService.class.getResourceAsStream("/yggdrasil_session_pubkey.der");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int length = -1;
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            out.close();
            SIGNATURE_KEY = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(out.toByteArray()));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Missing/invalid yggdrasil public key.");
        }
        GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDSerializer()).create();
    }

    private static class MinecraftTexturesPayload {
        public long timestamp;
        public UUID profileId;
        public String profileName;
        public boolean isPublic;
        public Map<TextureType, Texture> textures;

        private MinecraftTexturesPayload() {
        }
    }

    public static class Texture {
        private String url;
        private Map<String, String> metadata;

        public Texture(String url, Map<String, String> metadata) {
            this.url = url;
            this.metadata = new HashMap<String, String>(metadata);
        }

        public String getURL() {
            return this.url;
        }

        public String getMetadata(String key) {
            return this.metadata != null ? this.metadata.get(key) : null;
        }

        public TextureModel getModel() {
            String model = this.getMetadata("model");
            return model != null && model.equals("slim") ? TextureModel.SLIM : TextureModel.NORMAL;
        }

        public String getHash() {
            String url = this.url.endsWith("/") ? this.url.substring(0, this.url.length() - 1) : this.url;
            int slash = url.lastIndexOf("/");
            int dot = url.lastIndexOf(".");
            if (dot < slash) {
                dot = url.length();
            }
            return url.substring(slash + 1, dot != -1 ? dot : url.length());
        }

        public String toString() {
            return "Texture{url=" + this.url + ", model=" + (Object)((Object)this.getModel()) + ", hash=" + this.getHash() + "}";
        }
    }

    public static enum TextureModel {
        NORMAL,
        SLIM;

    }

    public static enum TextureType {
        SKIN,
        CAPE,
        ELYTRA;

    }

    public static class Property {
        private String name;
        private String value;
        private String signature;

        public Property(String name, String value) {
            this(name, value, null);
        }

        public Property(String name, String value, String signature) {
            this.name = name;
            this.value = value;
            this.signature = signature;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasSignature() {
            return this.signature != null;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isSignatureValid(PublicKey key) throws SignatureValidateException {
            if (!this.hasSignature()) {
                return false;
            }
            try {
                Signature sig = Signature.getInstance("SHA1withRSA");
                sig.initVerify(key);
                sig.update(this.value.getBytes());
                return sig.verify(Base64.decode(this.signature.getBytes("UTF-8")));
            }
            catch (Exception e) {
                throw new SignatureValidateException("Could not validate property signature.", e);
            }
        }

        public String toString() {
            return "Property{name=" + this.name + ", value=" + this.value + ", signature=" + this.signature + "}";
        }
    }
}

