/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.obfuscate.DontObfuscate;
import org.slf4j.Logger;

public abstract class MinecraftServer
extends bcs<adv>
implements dq,
AutoCloseable {
    private static final Logger n = LogUtils.getLogger();
    public static final String b = "vanilla";
    private static final float o = 0.8f;
    private static final int p = 100;
    public static final int c = 50;
    private static final int q = 2000;
    private static final int r = 15000;
    private static final long s = 5000000000L;
    private static final int t = 12;
    public static final int d = 11;
    private static final int u = 441;
    private static final int v = 6000;
    private static final int w = 3;
    public static final int e = 29999984;
    public static final cmm f = new cmm("Demo World", cmf.a, false, bdv.c, false, new cme(), cna.c);
    private static final long x = 50L;
    public static final GameProfile g = new GameProfile(ac.c, "Anonymous Player");
    protected final dye.c h;
    protected final dyh i;
    private final List<Runnable> y = Lists.newArrayList();
    private bca z = bbz.a;
    private bao A = this.z.f();
    private Consumer<ban> B = $$0 -> this.aR();
    private Consumer<Path> C = $$0 -> {};
    private boolean D;
    @Nullable
    private c E;
    private boolean F;
    private final ajh G;
    private final aiz H;
    @Nullable
    private acg I;
    @Nullable
    private acg.a J;
    private final apo K = apo.a();
    private final DataFixer L;
    private String M;
    private int N = -1;
    private final hk<adm> O;
    private final Map<adc<cmi>, aip> P = Maps.newLinkedHashMap();
    private alu Q;
    private volatile boolean R = true;
    private boolean S;
    private int T;
    protected final Proxy j;
    private boolean U;
    private boolean V;
    private boolean W;
    private boolean X;
    @Nullable
    private String Y;
    private int Z;
    public final long[] k = new long[100];
    @Nullable
    private KeyPair aa;
    @Nullable
    private GameProfile ab;
    private boolean ac;
    private volatile boolean ad;
    private long ae;
    protected final adu l;
    private long af;
    private final Thread ag;
    private long ah = ac.b();
    private long ai;
    private boolean aj;
    private final aks ak;
    private final adt al = new adt(this);
    @Nullable
    private dxx am;
    private final aeb an = new aeb();
    private final adr ao;
    private final aox ap = new aox();
    private boolean aq;
    private float ar;
    private final Executor as;
    @Nullable
    private String at;
    private a au;
    private final dvi av;
    protected final dyk m;
    private volatile boolean aw;

    public static <S extends MinecraftServer> S a(Function<Thread, S> $$02) {
        AtomicReference<MinecraftServer> $$12 = new AtomicReference<MinecraftServer>();
        Thread $$2 = new Thread(() -> ((MinecraftServer)$$12.get()).w(), "Server thread");
        $$2.setUncaughtExceptionHandler(($$0, $$1) -> n.error("Uncaught exception in server thread", $$1));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            $$2.setPriority(8);
        }
        MinecraftServer $$3 = (MinecraftServer)$$02.apply($$2);
        $$12.set($$3);
        $$2.start();
        return (S)$$3;
    }

    public MinecraftServer(Thread $$02, dye.c $$1, aks $$2, adx $$3, Proxy $$4, DataFixer $$5, adu $$6, aiz $$7) {
        super("Server");
        this.O = $$3.c();
        this.m = $$3.d();
        if (!this.O.a().d(jb.aG).c(dfa.b)) {
            throw new IllegalStateException("Missing Overworld dimension data");
        }
        this.j = $$4;
        this.ak = $$2;
        this.au = new a($$3.a(), $$3.b());
        this.l = $$6;
        if ($$6.d() != null) {
            $$6.d().a(this);
        }
        this.G = new ajh(this);
        this.H = $$7;
        this.h = $$1;
        this.i = $$1.b();
        this.L = $$5;
        this.ao = new adr(this, this.au.b.a());
        hf<cpi> $$8 = this.O.a().d(jb.e).p().a(this.m.L());
        this.av = new dvi($$3.a(), $$1, $$5, $$8);
        this.ag = $$02;
        this.as = ac.f();
    }

    @Override
    private void a(dya $$0) {
        $$0.a(this.aF()::a, this.aF()::b, "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void g_() {
        if (!bau.e.c()) {
            // empty if block
        }
        boolean $$0 = false;
        bax $$1 = bau.e.e();
        this.m.a(this.getServerModName(), this.K().a());
        aiy $$2 = this.H.create(11);
        this.a($$2);
        this.r();
        this.b($$2);
        if ($$1 != null) {
            $$1.finish();
        }
        if ($$0) {
            try {
                bau.e.b();
            }
            catch (Throwable $$3) {
                n.warn("Failed to stop JFR profiling", $$3);
            }
        }
    }

    protected void r() {
    }

    @Override
    protected void a(aiy $$0) {
        dyj $$1 = this.m.J();
        boolean $$2 = this.m.C();
        hq<dfa> $$3 = this.O.a().d(jb.aG);
        dhx $$4 = this.m.A();
        long $$5 = $$4.b();
        long $$6 = cnh.a($$5);
        ImmutableList $$7 = ImmutableList.of((Object)new dhl(), (Object)new dhk(), (Object)new bxv(), (Object)new bqv(), (Object)new byg($$1));
        dfa $$8 = $$3.a(dfa.b);
        aip $$9 = new aip(this, this.as, this.h, $$1, cmi.h, $$8, $$0, $$2, $$6, (List<clv>)$$7, true);
        this.P.put(cmi.h, $$9);
        dya $$10 = $$9.s();
        this.a($$10);
        this.am = new dxx($$10);
        ddi $$11 = $$9.p_();
        if (!$$1.p()) {
            try {
                MinecraftServer.a($$9, $$1, $$4.d(), $$2);
                $$1.c(true);
                if ($$2) {
                    this.a(this.m);
                }
            }
            catch (Throwable $$12) {
                o $$13 = o.a($$12, "Exception initializing level");
                try {
                    $$9.a($$13);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new y($$13);
            }
            $$1.c(true);
        }
        this.ac().a($$9);
        if (this.m.G() != null) {
            this.aL().a(this.m.G());
        }
        for (Map.Entry<adc<dfa>, dfa> $$14 : $$3.g()) {
            adc<dfa> $$15 = $$14.getKey();
            if ($$15 == dfa.b) continue;
            adc<cmi> $$16 = adc.a(jb.aF, $$15.a());
            dxz $$17 = new dxz(this.m, $$1);
            aip $$18 = new aip(this, this.as, this.h, $$17, $$16, $$14.getValue(), $$0, $$2, $$6, (List<clv>)ImmutableList.of(), false);
            $$11.a(new ddg.a($$18.p_()));
            this.P.put($$16, $$18);
        }
        $$11.a($$1.r());
    }

    private static void a(aip $$02, dyj $$1, boolean $$2, boolean $$32) {
        if ($$32) {
            $$1.a(gt.b.b(80), 0.0f);
            return;
        }
        ain $$4 = $$02.k();
        clp $$5 = new clp($$4.i().b().a());
        int $$6 = $$4.g().a($$02);
        if ($$6 < $$02.v_()) {
            gt $$7 = $$5.l();
            $$6 = $$02.a(dgz.a.b, $$7.u() + 8, $$7.w() + 8);
        }
        $$1.a($$5.l().b(8, $$6, 8), 0.0f);
        int $$8 = 0;
        int $$9 = 0;
        int $$10 = 0;
        int $$11 = -1;
        int $$12 = 5;
        for (int $$13 = 0; $$13 < apj.h(11); ++$$13) {
            gt $$14;
            if ($$8 >= -5 && $$8 <= 5 && $$9 >= -5 && $$9 <= 5 && ($$14 = aik.a($$02, new clp($$5.e + $$8, $$5.f + $$9))) != null) {
                $$1.a($$14, 0.0f);
                break;
            }
            if ($$8 == $$9 || $$8 < 0 && $$8 == -$$9 || $$8 > 0 && $$8 == 1 - $$9) {
                int $$15 = $$10;
                $$10 = -$$11;
                $$11 = $$15;
            }
            $$8 += $$10;
            $$9 += $$11;
        }
        if ($$2) {
            $$02.u_().c(jb.aq).flatMap($$0 -> $$0.b(pa.m)).ifPresent($$3 -> ((djq)$$3.a()).a($$02, $$4.g(), $$0.z, new gt($$1.a(), $$1.b(), $$1.c())));
        }
    }

    @Override
    private void a(dyk $$0) {
        $$0.a(bdv.a);
        $$0.d(true);
        dyj $$1 = $$0.J();
        $$1.b(false);
        $$1.a(false);
        $$1.a(1000000000);
        $$1.b(6000L);
        $$1.a(cmf.d);
    }

    private void b(aiy $$0) {
        aip $$1 = this.D();
        n.info("Preparing start region for dimension {}", (Object)$$1.ab().a());
        gt $$2 = $$1.Q();
        $$0.a(new clp($$2));
        ain $$3 = $$1.k();
        $$3.a().a(500);
        this.ah = ac.b();
        $$3.a(aiu.a, new clp($$2), 11, aqi.a);
        while ($$3.b() != 441) {
            this.ah = ac.b() + 10L;
            this.i_();
        }
        this.ah = ac.b() + 10L;
        this.i_();
        for (aip $$4 : this.P.values()) {
            cmd $$5 = $$4.s().a(cmd::b, "chunks");
            if ($$5 == null) continue;
            LongIterator $$6 = $$5.a().iterator();
            while ($$6.hasNext()) {
                long $$7 = $$6.nextLong();
                clp $$8 = new clp($$7);
                $$4.k().a($$8, true);
            }
        }
        this.ah = ac.b() + 10L;
        this.i_();
        $$0.b();
        $$3.a().a(5);
        this.bu();
    }

    public cmf h_() {
        return this.m.m();
    }

    public boolean h() {
        return this.m.n();
    }

    public abstract int i();

    public abstract int j();

    public abstract boolean k();

    public boolean a(boolean $$0, boolean $$1, boolean $$2) {
        boolean $$3 = false;
        for (aip $$4 : this.F()) {
            if (!$$0) {
                n.info("Saving chunks for level '{}'/{}", (Object)$$4, (Object)$$4.ab().a());
            }
            $$4.a(null, $$1, $$4.e && !$$2);
            $$3 = true;
        }
        aip $$5 = this.D();
        dyj $$6 = this.m.J();
        $$6.a($$5.p_().t());
        this.m.b(this.aL().c());
        this.h.a(this.aX(), this.m, this.ac().r());
        if ($$1) {
            for (aip $$7 : this.F()) {
                n.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)$$7.k().a.n());
            }
            n.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return $$3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean $$0, boolean $$1, boolean $$2) {
        try {
            this.aw = true;
            this.ac().h();
            boolean bl2 = this.a($$0, $$1, $$2);
            return bl2;
        }
        finally {
            this.aw = false;
        }
    }

    @Override
    public void close() {
        this.t();
    }

    public void t() {
        if (this.z.e()) {
            this.aT();
        }
        n.info("Stopping server");
        if (this.ad() != null) {
            this.ad().b();
        }
        this.aw = true;
        if (this.Q != null) {
            n.info("Saving players");
            this.Q.h();
            this.Q.s();
        }
        n.info("Saving worlds");
        for (aip $$02 : this.F()) {
            if ($$02 == null) continue;
            $$02.e = false;
        }
        while (this.P.values().stream().anyMatch($$0 -> $$0.k().a.f())) {
            this.ah = ac.b() + 1L;
            for (aip $$1 : this.F()) {
                $$1.k().o();
                $$1.k().a(() -> true, false);
            }
            this.i_();
        }
        this.a(false, true, false);
        for (aip $$2 : this.F()) {
            if ($$2 == null) continue;
            try {
                $$2.close();
            }
            catch (IOException $$3) {
                n.error("Exception closing the level", (Throwable)$$3);
            }
        }
        this.aw = false;
        this.au.close();
        try {
            this.h.close();
        }
        catch (IOException $$4) {
            n.error("Failed to unlock level {}", (Object)this.h.a(), (Object)$$4);
        }
    }

    public String u() {
        return this.M;
    }

    public void a_(String $$0) {
        this.M = $$0;
    }

    public boolean v() {
        return this.R;
    }

    @Override
    public void a(boolean $$0) {
        this.R = false;
        if ($$0) {
            try {
                this.ag.join();
            }
            catch (InterruptedException $$1) {
                n.error("Error while shutting down", (Throwable)$$1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void w() {
        block25: {
            try {
                if (this.e()) {
                    this.ah = ac.b();
                    this.J = this.bj().orElse(null);
                    this.I = this.bk();
                    while (this.R) {
                        long $$0 = ac.b() - this.ah;
                        if ($$0 > 2000L && this.ah - this.ae >= 15000L) {
                            long $$1 = $$0 / 50L;
                            n.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)$$0, (Object)$$1);
                            this.ah += $$1 * 50L;
                            this.ae = this.ah;
                        }
                        if (this.F) {
                            this.F = false;
                            this.E = new c(ac.c(), this.T);
                        }
                        this.ah += 50L;
                        this.bv();
                        this.A.a("tick");
                        this.a(this::bh);
                        this.A.b("nextTickWait");
                        this.aj = true;
                        this.ai = Math.max(ac.b() + 50L, this.ah);
                        this.i_();
                        this.A.c();
                        this.bw();
                        this.ad = true;
                        bau.e.a(this.ar);
                    }
                    break block25;
                }
                throw new IllegalStateException("Failed to initialize server");
            }
            catch (Throwable $$3) {
                n.error("Encountered an unexpected exception", $$3);
                o $$4 = MinecraftServer.a($$3);
                this.b($$4.g());
                File $$5 = new File(new File(this.z(), "crash-reports"), "crash-" + ac.e() + "-server.txt");
                if ($$4.a($$5)) {
                    n.error("This crash report has been saved to: {}", (Object)$$5.getAbsolutePath());
                } else {
                    n.error("We were unable to save this crash report to disk.");
                }
                this.a($$4);
            }
            finally {
                try {
                    this.S = true;
                    this.t();
                }
                catch (Throwable $$2) {
                    n.error("Exception stopping the server", $$2);
                }
                finally {
                    if (this.l.d() != null) {
                        this.l.d().a();
                    }
                    this.g();
                }
            }
        }
    }

    private static o a(Throwable $$0) {
        o $$5;
        y $$1 = null;
        for (Throwable $$2 = $$0; $$2 != null; $$2 = $$2.getCause()) {
            y $$3;
            if (!($$2 instanceof y)) continue;
            $$1 = $$3 = (y)$$2;
        }
        if ($$1 != null) {
            o $$4 = $$1.a();
            if ($$1 != $$0) {
                $$4.a("Wrapped in").a("Wrapping exception", $$0);
            }
        } else {
            $$5 = new o("Exception in server tick loop", $$0);
        }
        return $$5;
    }

    private boolean bh() {
        return this.bt() || ac.b() < (this.aj ? this.ai : this.ah);
    }

    protected void i_() {
        this.br();
        this.c(() -> !this.bh());
    }

    protected adv a(Runnable $$0) {
        return new adv(this.T, $$0);
    }

    protected boolean a(adv $$0) {
        return $$0.a() + 3 < this.T || this.bh();
    }

    @Override
    public boolean x() {
        boolean $$0;
        this.aj = $$0 = this.bi();
        return $$0;
    }

    private boolean bi() {
        if (super.x()) {
            return true;
        }
        if (this.bh()) {
            for (aip $$0 : this.F()) {
                if (!$$0.k().d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void b(adv $$0) {
        this.aP().d("runTask");
        super.d($$0);
    }

    private Optional<acg.a> bj() {
        Optional<Path> $$02 = Optional.of(this.c("server-icon.png").toPath()).filter($$0 -> Files.isRegularFile($$0, new LinkOption[0])).or(() -> this.h.e().filter($$0 -> Files.isRegularFile($$0, new LinkOption[0])));
        return $$02.flatMap($$0 -> {
            try {
                BufferedImage $$1 = ImageIO.read($$0.toFile());
                Preconditions.checkState(($$1.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState(($$1.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream $$2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)$$1, "PNG", $$2);
                return Optional.of(new acg.a($$2.toByteArray()));
            }
            catch (Exception $$3) {
                n.error("Couldn't load server icon", (Throwable)$$3);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> y() {
        return this.h.e();
    }

    public File z() {
        return new File(".");
    }

    @Override
    public void a(o $$0) {
    }

    public void g() {
    }

    @Override
    public void a(BooleanSupplier $$0) {
        long $$1 = ac.c();
        ++this.T;
        this.b($$0);
        if ($$1 - this.af >= 5000000000L) {
            this.af = $$1;
            this.I = this.bk();
        }
        if (this.T % 6000 == 0) {
            n.debug("Autosave started");
            this.A.a("save");
            this.b(true, false, false);
            this.A.c();
            n.debug("Autosave finished");
        }
        this.A.a("tallying");
        long l2 = ac.c() - $$1;
        this.k[this.T % 100] = l2;
        long $$2 = l2;
        this.ar = this.ar * 0.8f + (float)$$2 / 1000000.0f * 0.19999999f;
        long $$3 = ac.c();
        this.ap.a($$3 - $$1);
        this.A.c();
    }

    private acg bk() {
        acg.b $$0 = this.bl();
        return new acg(tj.a(this.Y), Optional.of($$0), Optional.of(acg.c.a()), Optional.ofNullable(this.J), this.aw());
    }

    private acg.b bl() {
        List<aiq> $$0 = this.Q.t();
        int $$1 = this.I();
        if (this.aj()) {
            return new acg.b($$1, $$0.size(), List.of());
        }
        int $$2 = Math.min($$0.size(), 12);
        ObjectArrayList $$3 = new ObjectArrayList($$2);
        int $$4 = apj.a(this.K, 0, $$0.size() - $$2);
        for (int $$5 = 0; $$5 < $$2; ++$$5) {
            aiq $$6 = $$0.get($$4 + $$5);
            $$3.add((Object)($$6.V() ? $$6.fI() : g));
        }
        ac.b($$3, this.K);
        return new acg.b($$1, $$0.size(), (List<GameProfile>)$$3);
    }

    public void b(BooleanSupplier $$0) {
        this.A.a("commandFunctions");
        this.aA().c();
        this.A.b("levels");
        for (aip $$1 : this.F()) {
            this.A.a(() -> $$1 + " " + $$1.ab().a());
            if (this.T % 20 == 0) {
                this.A.a("timeSync");
                this.b($$1);
                this.A.c();
            }
            this.A.a("tick");
            try {
                $$1.a($$0);
            }
            catch (Throwable $$2) {
                o $$3 = o.a($$2, "Exception ticking world");
                $$1.a($$3);
                throw new y($$3);
            }
            this.A.c();
            this.A.c();
        }
        this.A.b("connection");
        this.ad().c();
        this.A.b("players");
        this.Q.d();
        if (aa.aO) {
            qk.a.b();
        }
        this.A.b("server gui refresh");
        for (int $$4 = 0; $$4 < this.y.size(); ++$$4) {
            this.y.get($$4).run();
        }
        this.A.c();
    }

    private void b(aip $$0) {
        this.Q.a(new yv($$0.U(), $$0.V(), $$0.W().b(cme.k)), $$0.ab());
    }

    public void A() {
        this.A.a("timeSync");
        for (aip $$0 : this.F()) {
            this.b($$0);
        }
        this.A.c();
    }

    public boolean B() {
        return true;
    }

    public void b(Runnable $$0) {
        this.y.add($$0);
    }

    protected void b(String $$0) {
        this.at = $$0;
    }

    public boolean C() {
        return !this.ag.isAlive();
    }

    public File c(String $$0) {
        return new File(this.z(), $$0);
    }

    public final aip D() {
        return this.P.get(cmi.h);
    }

    @Nullable
    public aip a(adc<cmi> $$0) {
        return this.P.get($$0);
    }

    public Set<adc<cmi>> E() {
        return this.P.keySet();
    }

    public Iterable<aip> F() {
        return this.P.values();
    }

    public String G() {
        return aa.b().c();
    }

    public int H() {
        return this.Q.m();
    }

    public int I() {
        return this.Q.n();
    }

    public String[] J() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return b;
    }

    public ab b(ab $$0) {
        $$0.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            $$0.a("Player Count", () -> this.Q.m() + " / " + this.Q.n() + "; " + this.Q.t());
        }
        $$0.a("Data Packs", () -> this.ak.f().stream().map($$0 -> $$0.f() + ($$0.c().a() ? "" : " (incompatible)")).collect(Collectors.joining(", ")));
        $$0.a("Enabled Feature Flags", () -> caw.d.b(this.m.L()).stream().map(add::toString).collect(Collectors.joining(", ")));
        $$0.a("World Generation", () -> this.m.D().toString());
        if (this.at != null) {
            $$0.a("Server Id", () -> this.at);
        }
        return this.a($$0);
    }

    public abstract ab a(ab var1);

    public api K() {
        return api.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(tj $$0) {
        n.info($$0.getString());
    }

    public KeyPair L() {
        return this.aa;
    }

    public int M() {
        return this.N;
    }

    @Override
    public void a(int $$0) {
        this.N = $$0;
    }

    @Nullable
    public GameProfile N() {
        return this.ab;
    }

    public void b(@Nullable GameProfile $$0) {
        this.ab = $$0;
    }

    public boolean O() {
        return this.ab != null;
    }

    protected void P() {
        n.info("Generating keypair");
        try {
            this.aa = aoj.b();
        }
        catch (aok $$0) {
            throw new IllegalStateException("Failed to generate key pair", $$0);
        }
    }

    public void a(bdv $$0, boolean $$1) {
        if (!$$1 && this.m.t()) {
            return;
        }
        this.m.a(this.m.n() ? bdv.d : $$0);
        this.bu();
        this.ac().t().forEach(this::c);
    }

    public int b(int $$0) {
        return $$0;
    }

    private void bu() {
        for (aip $$0 : this.F()) {
            $$0.b(this.Q(), this.W());
        }
    }

    public void b(boolean $$0) {
        this.m.d($$0);
        this.ac().t().forEach(this::c);
    }

    private void c(aiq $$0) {
        dyb $$1 = $$0.x().n_();
        $$0.b.a(new vr($$1.s(), $$1.t()));
    }

    public boolean Q() {
        return this.m.s() != bdv.a;
    }

    public boolean R() {
        return this.ac;
    }

    public void c(boolean $$0) {
        this.ac = $$0;
    }

    public Optional<b> S() {
        return Optional.empty();
    }

    public boolean T() {
        return this.S().filter(b::c).isPresent();
    }

    public abstract boolean l();

    public abstract int m();

    public boolean U() {
        return this.U;
    }

    @Override
    public void d(boolean $$0) {
        this.U = $$0;
    }

    public boolean V() {
        return this.V;
    }

    public void e(boolean $$0) {
        this.V = $$0;
    }

    public boolean W() {
        return true;
    }

    public boolean X() {
        return true;
    }

    public abstract boolean n();

    public boolean Y() {
        return this.W;
    }

    public void f(boolean $$0) {
        this.W = $$0;
    }

    public boolean Z() {
        return this.X;
    }

    public void g(boolean $$0) {
        this.X = $$0;
    }

    public abstract boolean o();

    public String aa() {
        return this.Y;
    }

    @Override
    public void d(String $$0) {
        this.Y = $$0;
    }

    public boolean ab() {
        return this.S;
    }

    public alu ac() {
        return this.Q;
    }

    @Override
    public void a(alu $$0) {
        this.Q = $$0;
    }

    public abstract boolean p();

    @Override
    public void a(cmf $$0) {
        this.m.a($$0);
    }

    @Nullable
    public ajh ad() {
        return this.G;
    }

    public boolean ae() {
        return this.ad;
    }

    public boolean af() {
        return false;
    }

    public boolean a(@Nullable cmf $$0, boolean $$1, int $$2) {
        return false;
    }

    public int ag() {
        return this.T;
    }

    public int ah() {
        return 16;
    }

    public boolean a(aip $$0, gt $$1, bym $$2) {
        return false;
    }

    public boolean ai() {
        return true;
    }

    public boolean aj() {
        return false;
    }

    public Proxy ak() {
        return this.j;
    }

    public int al() {
        return this.Z;
    }

    public void c(int $$0) {
        this.Z = $$0;
    }

    public MinecraftSessionService am() {
        return this.l.a();
    }

    public aps an() {
        return this.l.b();
    }

    public GameProfileRepository ao() {
        return this.l.c();
    }

    public alq ap() {
        return this.l.d();
    }

    @Nullable
    public acg aq() {
        return this.I;
    }

    public void ar() {
        this.af = 0L;
    }

    public int as() {
        return 29999984;
    }

    @Override
    public boolean at() {
        return super.at() && !this.ab();
    }

    @Override
    public void c(Runnable $$0) {
        if (this.ab()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c($$0);
    }

    @Override
    public Thread au() {
        return this.ag;
    }

    public int av() {
        return 256;
    }

    public boolean aw() {
        return false;
    }

    public long ax() {
        return this.ah;
    }

    public DataFixer ay() {
        return this.L;
    }

    public int a(@Nullable aip $$0) {
        if ($$0 != null) {
            return $$0.W().c(cme.r);
        }
        return 10;
    }

    public adp az() {
        return this.au.b.g();
    }

    public adr aA() {
        return this.ao;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> $$0) {
        hr.b $$13 = this.O.b(adm.d);
        CompletionStage $$2 = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)$$0.stream().map(this.ak::c).filter(Objects::nonNull).map(akq::e).collect(ImmutableList.toImmutableList()), this).thenCompose($$12 -> {
            ala $$22 = new ala(ajw.b, (List<ajv>)$$12);
            return ((CompletableFuture)adn.a($$22, $$13, this.m.L(), this.l() ? ds.a.b : ds.a.c, this.j(), this.as, this).whenComplete(($$1, $$2) -> {
                if ($$2 != null) {
                    $$22.close();
                }
            })).thenApply($$1 -> new a($$22, (adn)$$1));
        })).thenAcceptAsync($$1 -> {
            this.au.close();
            this.au = $$1;
            this.ak.a($$0);
            cna $$2 = new cna(MinecraftServer.a(this.ak), this.m.L());
            this.m.a($$2);
            this.au.b.a(this.aX());
            this.ac().h();
            this.ac().u();
            this.ao.a(this.au.b.a());
            this.av.a(this.au.a);
        }, (Executor)this);
        if (this.bn()) {
            this.c(((CompletableFuture)$$2)::isDone);
        }
        return $$2;
    }

    public static cna a(aks $$0, clw $$1, boolean $$2, cau $$3) {
        $$0.a();
        if ($$2) {
            $$0.a(Collections.singleton(b));
            return cna.c;
        }
        LinkedHashSet $$4 = Sets.newLinkedHashSet();
        for (String $$5 : $$1.a()) {
            if ($$0.d($$5)) {
                $$4.add($$5);
                continue;
            }
            n.warn("Missing data pack {}", (Object)$$5);
        }
        for (akq $$6 : $$0.c()) {
            String $$7 = $$6.f();
            if ($$1.b().contains($$7)) continue;
            cau $$8 = $$6.d();
            boolean $$9 = $$4.contains($$7);
            if (!$$9 && $$6.j().a()) {
                if ($$8.a($$3)) {
                    n.info("Found new data pack {}, loading it automatically", (Object)$$7);
                    $$4.add($$7);
                } else {
                    n.info("Found new data pack {}, but can't load it due to missing features {}", (Object)$$7, (Object)caw.a($$3, $$8));
                }
            }
            if (!$$9 || $$8.a($$3)) continue;
            n.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)$$7, (Object)caw.a($$3, $$8));
            $$4.remove($$7);
        }
        if ($$4.isEmpty()) {
            n.info("No datapacks selected, forcing vanilla");
            $$4.add(b);
        }
        $$0.a($$4);
        clw $$10 = MinecraftServer.a($$0);
        cau $$11 = $$0.e();
        return new cna($$10, $$11);
    }

    private static clw a(aks $$0) {
        Collection<String> $$12 = $$0.d();
        ImmutableList $$2 = ImmutableList.copyOf($$12);
        List $$3 = (List)$$0.b().stream().filter($$1 -> !$$12.contains($$1)).collect(ImmutableList.toImmutableList());
        return new clw((List<String>)$$2, $$3);
    }

    @Override
    public void a(dr $$0) {
        if (!this.aM()) {
            return;
        }
        alu $$1 = $$0.l().ac();
        amc $$2 = $$1.i();
        ArrayList $$3 = Lists.newArrayList($$1.t());
        for (aiq $$4 : $$3) {
            if ($$2.a($$4.fI())) continue;
            $$4.b.b(tj.c("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public aks aB() {
        return this.ak;
    }

    public ds aC() {
        return this.au.b.f();
    }

    public dr aD() {
        aip $$0 = this.D();
        return new dr(this, $$0 == null ? ede.b : ede.a($$0.Q()), edd.a, $$0, 4, "Server", tj.b("Server"), this, null);
    }

    @Override
    public boolean d_() {
        return true;
    }

    @Override
    public boolean j_() {
        return true;
    }

    @Override
    public abstract boolean M_();

    public ciz aE() {
        return this.au.b.e();
    }

    public adt aF() {
        return this.al;
    }

    public dxx aG() {
        if (this.am == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.am;
    }

    public dyv aH() {
        return this.au.b.c();
    }

    public dyw aI() {
        return this.au.b.b();
    }

    public dyq aJ() {
        return this.au.b.d();
    }

    public cme aK() {
        return this.D().W();
    }

    public aeb aL() {
        return this.an;
    }

    public boolean aM() {
        return this.aq;
    }

    public void h(boolean $$0) {
        this.aq = $$0;
    }

    public float aN() {
        return this.ar;
    }

    public int c(GameProfile $$0) {
        if (this.ac().f($$0)) {
            alw $$1 = (alw)this.ac().k().b($$0);
            if ($$1 != null) {
                return $$1.a();
            }
            if (this.a($$0)) {
                return 4;
            }
            if (this.O()) {
                return this.ac().v() ? 4 : 0;
            }
            return this.i();
        }
        return 0;
    }

    public aox aO() {
        return this.ap;
    }

    public bao aP() {
        return this.A;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path $$0) throws IOException {
    }

    private void b(Path $$0) {
        Path $$1 = $$0.resolve("levels");
        try {
            for (Map.Entry<adc<cmi>, aip> $$2 : this.P.entrySet()) {
                add $$3 = $$2.getKey().a();
                Path $$4 = $$1.resolve($$3.b()).resolve($$3.a());
                Files.createDirectories($$4, new FileAttribute[0]);
                $$2.getValue().a($$4);
            }
            this.d($$0.resolve("gamerules.txt"));
            this.e($$0.resolve("classpath.txt"));
            this.c($$0.resolve("stats.txt"));
            this.f($$0.resolve("threads.txt"));
            this.a($$0.resolve("server.properties.txt"));
            this.g($$0.resolve("modules.txt"));
        }
        catch (IOException $$5) {
            n.warn("Failed to save debug report", (Throwable)$$5);
        }
    }

    private void c(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            $$1.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.bo()));
            $$1.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aN())));
            $$1.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.k)));
            $$1.write(String.format(Locale.ROOT, "queue: %s\n", ac.f()));
        }
    }

    @Override
    private void d(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            final ArrayList $$2 = Lists.newArrayList();
            final cme $$3 = this.aK();
            cme.a(new cme.c(){

                @Override
                public <T extends cme.g<T>> void a(cme.e<T> $$0, cme.f<T> $$1) {
                    $$2.add(String.format(Locale.ROOT, "%s=%s\n", $$0.a(), $$3.a($$0)));
                }
            });
            for (String $$4 : $$2) {
                $$1.write($$4);
            }
        }
    }

    private void e(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            String $$2 = System.getProperty("java.class.path");
            String $$3 = System.getProperty("path.separator");
            for (String $$4 : Splitter.on((String)$$3).split((CharSequence)$$2)) {
                $$1.write($$4);
                $$1.write("\n");
            }
        }
    }

    private void f(Path $$0) throws IOException {
        ThreadMXBean $$1 = ManagementFactory.getThreadMXBean();
        ThreadInfo[] $$2 = $$1.dumpAllThreads(true, true);
        Arrays.sort($$2, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter $$3 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            for (ThreadInfo $$4 : $$2) {
                $$3.write($$4.toString());
                ((Writer)$$3).write(10);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void g(Path $$02) throws IOException {
        BufferedWriter $$1 = Files.newBufferedWriter($$02, new OpenOption[0]);
        try {
            void $$4;
            try {
                ArrayList $$2 = Lists.newArrayList(apk.a());
            }
            catch (Throwable $$3) {
                n.warn("Failed to list native modules", $$3);
                if ($$1 != null) {
                    ((Writer)$$1).close();
                }
                return;
            }
            $$4.sort(Comparator.comparing($$0 -> $$0.a));
            for (apk.a $$5 : $$4) {
                $$1.write($$5.toString());
                ((Writer)$$1).write(10);
            }
        }
        finally {
            if ($$1 != null) {
                try {
                    ((Writer)$$1).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void bv() {
        if (this.D) {
            this.z = bby.a(new bcc(ac.a, this.l()), ac.a, ac.g(), new bce("server"), this.B, $$0 -> {
                this.h(() -> this.b($$0.resolve("server")));
                this.C.accept((Path)$$0);
            });
            this.D = false;
        }
        this.A = bar.a(this.z.f(), bar.a("Server"));
        this.z.c();
        this.A.a();
    }

    private void bw() {
        this.A.b();
        this.z.d();
    }

    public boolean aQ() {
        return this.z.e();
    }

    public void a(Consumer<ban> $$0, Consumer<Path> $$12) {
        this.B = $$1 -> {
            this.aR();
            $$0.accept((ban)$$1);
        };
        this.C = $$12;
        this.D = true;
    }

    public void aR() {
        this.z = bbz.a;
    }

    public void aS() {
        this.z.a();
    }

    public void aT() {
        this.z.b();
        this.A = this.z.f();
    }

    public Path a(dyc $$0) {
        return this.h.a($$0);
    }

    public boolean aU() {
        return true;
    }

    public dvi aV() {
        return this.av;
    }

    public dyk aW() {
        return this.m;
    }

    public hr.b aX() {
        return this.O.a();
    }

    public hk<adm> aY() {
        return this.O;
    }

    public ajn a(aiq $$0) {
        return ajn.a;
    }

    public air b(aiq $$0) {
        return this.R() ? new aih($$0) : new air($$0);
    }

    @Nullable
    public cmf aZ() {
        return null;
    }

    public alh ba() {
        return this.au.a;
    }

    public boolean bb() {
        return this.aw;
    }

    public boolean bc() {
        return this.F || this.E != null;
    }

    public void bd() {
        this.F = true;
    }

    public ban be() {
        if (this.E == null) {
            return baj.a;
        }
        ban $$0 = this.E.a(ac.c(), this.T);
        this.E = null;
        return $$0;
    }

    public int bf() {
        return 1000000;
    }

    public void a(tj $$0, tf.a $$1, @Nullable String $$2) {
        String $$3 = $$1.a($$0).getString();
        if ($$2 != null) {
            n.info("[{}] {}", (Object)$$2, (Object)$$3);
        } else {
            n.info("{}", (Object)$$3);
        }
    }

    public te bg() {
        return te.a;
    }

    @Override
    public /* synthetic */ void d(Runnable runnable) {
        this.b((adv)runnable);
    }

    @Override
    public /* synthetic */ boolean e(Runnable runnable) {
        return this.a((adv)runnable);
    }

    @Override
    public /* synthetic */ Runnable f(Runnable runnable) {
        return this.a(runnable);
    }

    static final class a
    extends Record
    implements AutoCloseable {
        final akx a;
        final adn b;

        a(akx $$0, adn $$1) {
            this.a = $$0;
            this.b = $$1;
        }

        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this, $$0);
        }

        public akx a() {
            return this.a;
        }

        public adn b() {
            return this.b;
        }
    }

    static class c {
        final long a;
        final int b;

        c(long $$0, int $$1) {
            this.a = $$0;
            this.b = $$1;
        }

        ban a(final long $$0, final int $$1) {
            return new ban(){

                @Override
                public List<baq> a(String $$02) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path $$02) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return $$0;
                }

                @Override
                public int d() {
                    return $$1;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record b(String a, String b, boolean c, @Nullable tj d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "url;hash;isRequired;prompt", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "url;hash;isRequired;prompt", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "url;hash;isRequired;prompt", "a", "b", "c", "d"}, this, $$0);
        }
    }
}

