/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin;

import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.dynamic.SparkDynamicManager;
import me.wesley1808.servercore.common.interfaces.IMinecraftServer;
import me.wesley1808.servercore.common.services.Environment;
import me.wesley1808.servercore.common.utils.Statistics;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin
implements IMinecraftServer {
    @Unique
    private DynamicManager dynamicManager;
    @Unique
    private Statistics statistics;

    @Override
    @Unique
    public void onStarted() {
        MinecraftServer server = (MinecraftServer)this;
        this.dynamicManager = Environment.SPARK ? new SparkDynamicManager(server) : new DynamicManager(server);
        this.statistics = new Statistics(server);
    }

    @Override
    @Unique
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    @Unique
    public DynamicManager getDynamicManager() {
        return this.dynamicManager;
    }
}

