/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import java.util.function.Function;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.ConfigEntry;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class ServerCoreCommand {
    private static final String VALUE = "value";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder node = class_2170.method_9247((String)"servercore");
        node.then(ServerCoreCommand.config());
        node.then(ServerCoreCommand.settings());
        if (CommandConfig.COMMAND_STATUS.get().booleanValue()) {
            node.then(class_2170.method_9247((String)"status").executes(ctx -> ServerCoreCommand.getStatus((class_2168)ctx.getSource())));
        }
        dispatcher.register(node);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sc").redirect((CommandNode)node.build()));
    }

    private static LiteralArgumentBuilder<class_2168> config() {
        LiteralArgumentBuilder config = (LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(Permission.require("command.config", 2));
        for (Config.Table table : Config.Table.values()) {
            LiteralArgumentBuilder child = class_2170.method_9247((String)table.key);
            try {
                Config.forEachEntry(table.clazz, (field, entry) -> {
                    String key = field.getName().toLowerCase();
                    Type type = ServerCoreCommand.getTypeFor(key, entry);
                    if (type != null) {
                        child.then(((LiteralArgumentBuilder)class_2170.method_9247((String)key).executes(ctx -> ServerCoreCommand.sendInfo((class_2168)ctx.getSource(), String.format("%s.%s", table.key, key), entry))).then((ArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)VALUE, type.argumentType).executes(type.function::apply)).suggests((ctx, suggestionsBuilder) -> Util.suggestAll(suggestionsBuilder, ServerCoreCommand.asString(entry.get()), ServerCoreCommand.asString(entry.getDefault())))));
                    }
                });
            }
            catch (Throwable throwable) {
                ServerCore.LOGGER.error("Exception thrown whilst registering commands!", throwable);
            }
            config.then((ArgumentBuilder)child);
        }
        if (Config.isConfigAvailable()) {
            config.then(class_2170.method_9247((String)"reload").executes(ctx -> ServerCoreCommand.saveOrReload((class_2168)ctx.getSource(), false)));
            config.then(class_2170.method_9247((String)"save").executes(ctx -> ServerCoreCommand.saveOrReload((class_2168)ctx.getSource(), true)));
        }
        return config;
    }

    private static LiteralArgumentBuilder<class_2168> settings() {
        LiteralArgumentBuilder settings = (LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(Permission.require("command.settings", 2));
        settings.then(class_2170.method_9247((String)"chunk_tick_distance").then(class_2170.method_9244((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)2, (int)128)).executes(ctx -> ServerCoreCommand.modify((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 1, "Chunk-tick distance", false))));
        settings.then(class_2170.method_9247((String)"view_distance").then(class_2170.method_9244((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)2, (int)128)).executes(ctx -> ServerCoreCommand.modify((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 2, "View distance", false))));
        settings.then(class_2170.method_9247((String)"simulation_distance").then(class_2170.method_9244((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)2, (int)128)).executes(ctx -> ServerCoreCommand.modify((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 3, "Simulation distance", false))));
        settings.then(class_2170.method_9247((String)"mobcaps").then(class_2170.method_9244((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(ctx -> ServerCoreCommand.modify((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 4, "Mobcaps", true))));
        return settings;
    }

    private static int sendInfo(class_2168 source, String key, ConfigEntry<Object> entry) {
        String message = String.format("<dark_aqua>Key: <green>%s\n<dark_aqua>Current value: <green>%s\n<dark_aqua>Default value: <green>%s\n<dark_aqua>Type: <green>%s", key, ServerCoreCommand.asString(entry.get()), ServerCoreCommand.asString(entry.getDefault()), entry.getType().getSimpleName());
        source.method_9226(Formatter.parse(message), false);
        return 1;
    }

    private static int modify(String key, ConfigEntry<Object> entry, Object value, class_2168 source) {
        if (value instanceof String) {
            String val = (String)value;
            value = val.replace("#N", "\n");
        }
        ServerCoreCommand.sendMessage(source, key, String.valueOf(value), entry.set(value));
        return 1;
    }

    private static int modify(class_2168 source, int value, int id, String setting, boolean percentage) {
        DynamicManager manager = DynamicManager.getInstance(source.method_9211());
        switch (id) {
            case 1: {
                DynamicSetting.CHUNK_TICK_DISTANCE.set(value, manager);
                break;
            }
            case 2: {
                DynamicSetting.VIEW_DISTANCE.set(value, manager);
                break;
            }
            case 3: {
                DynamicSetting.SIMULATION_DISTANCE.set(value, manager);
                break;
            }
            case 4: {
                DynamicSetting.MOBCAP_MULTIPLIER.set((double)value / 100.0, manager);
            }
        }
        ServerCoreCommand.sendMessage(source, setting, value + (percentage ? "%" : ""), true);
        return 1;
    }

    private static int saveOrReload(class_2168 source, boolean saved) {
        if (saved) {
            Config.save();
        } else {
            Config.load(true);
        }
        source.method_9226((class_2561)class_2561.method_43470((String)(saved ? "Config saved!" : "Config reloaded!")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int getStatus(class_2168 source) {
        class_2561 component = Formatter.parse(DynamicManager.createStatusReport(Formatter.line(CommandConfig.STATUS_TITLE.get(), 40, source.method_43737())));
        source.method_9226(component, false);
        return 1;
    }

    private static void sendMessage(class_2168 source, String key, String value, boolean success) {
        if (success) {
            source.method_9226(Formatter.parse(String.format("<green>%s <dark_aqua>has been set to <green>%s", key, value)), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)String.format("%s cannot be set to %s!", key, value)));
        }
    }

    private static Type getTypeFor(String key, ConfigEntry<Object> entry) {
        return switch (entry.getType().getSimpleName()) {
            case "Boolean" -> new Type((ArgumentType<?>)BoolArgumentType.bool(), ctx -> ServerCoreCommand.modify(key, entry, BoolArgumentType.getBool((CommandContext)ctx, (String)VALUE), (class_2168)ctx.getSource()));
            case "Integer" -> new Type((ArgumentType<?>)LongArgumentType.longArg((long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE), ctx -> ServerCoreCommand.modify(key, entry, (int)LongArgumentType.getLong((CommandContext)ctx, (String)VALUE), (class_2168)ctx.getSource()));
            case "Double" -> new Type((ArgumentType<?>)DoubleArgumentType.doubleArg(), ctx -> ServerCoreCommand.modify(key, entry, DoubleArgumentType.getDouble((CommandContext)ctx, (String)VALUE), (class_2168)ctx.getSource()));
            case "String" -> new Type((ArgumentType<?>)StringArgumentType.greedyString(), ctx -> ServerCoreCommand.modify(key, entry, StringArgumentType.getString((CommandContext)ctx, (String)VALUE), (class_2168)ctx.getSource()));
            default -> null;
        };
    }

    private static String asString(Object obj) {
        String string;
        if (obj instanceof String) {
            String string2 = (String)obj;
            string = string2.replace("\n", "#N");
        } else {
            string = String.valueOf(obj);
        }
        return string;
    }

    private record Type(ArgumentType<?> argumentType, Function<CommandContext<class_2168>, Integer> function) {
    }
}

