/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import net.minecraft.class_3797;
import org.slf4j.Logger;
import xyz.jpenilla.betterfabricconsole.remap.MappingsDownloader;
import xyz.jpenilla.betterfabricconsole.remap.MojangMappingsDownloader;
import xyz.jpenilla.betterfabricconsole.remap.YarnMappingsDownloader;

public final class MappingsCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final String MINECRAFT_VERSION = class_3797.method_16672().method_48018();
    static final String DATA_PATH = "data";
    static final String MAPPINGS_PATH = "mappings";
    static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0000");
    static final Gson GSON = new GsonBuilder().create();
    final Path cache;

    public MappingsCache(Path cache) {
        this.cache = cache;
    }

    public MappingsDownloader<MojangMappingsDownloader.MojangMappingsData> createMojangMappingsDownloader() {
        return new MojangMappingsDownloader(this);
    }

    public MappingsDownloader<YarnMappingsDownloader.YarnData> createYarnMappingsDownloader() {
        return new YarnMappingsDownloader(this);
    }

    static void downloadFile(String url, Path dest) throws IOException {
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        Path tempDest = dest.resolveSibling(dest.getFileName().toString() + ".download.tmp");
        Files.deleteIfExists(tempDest);
        LOGGER.info("Downloading " + url + "...");
        long start = System.currentTimeMillis();
        try (ReadableByteChannel downloadChannel = Channels.newChannel(new URL(url).openStream());
             FileOutputStream outputStream = new FileOutputStream(tempDest.toFile());){
            outputStream.getChannel().transferFrom(downloadChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException ex) {
            Files.deleteIfExists(tempDest);
            throw ex;
        }
        Files.move(tempDest, dest, StandardCopyOption.REPLACE_EXISTING);
        LOGGER.info("Done in {} seconds.", (Object)DECIMAL_FORMAT.format((double)(System.currentTimeMillis() - start) / 1000.0));
    }
}

