/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.console;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.MinecraftServer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import xyz.jpenilla.betterfabricconsole.util.Util;

public record MinecraftCommandCompleter(MinecraftServer server) implements Completer
{
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        StringReader stringReader = Util.prepareStringReader(line.line());
        ParseResults results = this.server.method_3734().method_9235().parse(stringReader, (Object)this.server.method_3739());
        CompletableFuture suggestionsFuture = this.server.method_3734().method_9235().getCompletionSuggestions(results, line.cursor());
        Suggestions suggestions = (Suggestions)suggestionsFuture.join();
        for (Suggestion suggestion : suggestions.getList()) {
            String tooltipString;
            String suggestionText = suggestion.getText();
            if (suggestionText.isEmpty()) continue;
            Message suggestionTooltip = suggestion.getTooltip();
            String description = suggestionTooltip == null ? null : ((tooltipString = suggestionTooltip.getString()).isEmpty() ? null : tooltipString);
            candidates.add(new Candidate(suggestionText, suggestionText, null, description, null, null, false));
        }
    }
}

