/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.warps;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.codedsakura.blossom.lib.data.ListDataController;
import dev.codedsakura.blossom.warps.Warp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;

class WarpController
extends ListDataController<Warp>
implements SuggestionProvider<class_2168> {
    WarpController() {
    }

    public List<Warp> defaultData() {
        return new ArrayList<Warp>();
    }

    public String getFilename() {
        return "BlossomWarps";
    }

    public Class<Warp[]> getArrayClassType() {
        return Warp[].class;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase();
        ((List)this.data).stream().map(v -> v.name).sorted(String::compareToIgnoreCase).filter(pair -> pair.toLowerCase().startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    Warp findWarp(String name) {
        for (Warp warp : (List)this.data) {
            if (!warp.name.equals(name)) continue;
            return warp;
        }
        return null;
    }

    boolean addWarp(Warp warp) {
        if (this.findWarp(warp.name) != null) {
            return false;
        }
        ((List)this.data).add(warp);
        this.write();
        return true;
    }

    List<Warp> getWarps() {
        return (List)this.data;
    }

    boolean removeWarp(String name) {
        return ((List)this.data).removeIf(warp -> warp.name.equals(name));
    }
}

