/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.world;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import org.apache.commons.io.FileUtils;
import xaero.map.WorldMap;
import xaero.map.file.RegionDetection;
import xaero.map.highlight.DimensionHighlighterHandler;
import xaero.map.highlight.HighlighterRegistry;
import xaero.map.region.LeveledRegion;
import xaero.map.region.LeveledRegionManager;
import xaero.map.region.MapRegion;
import xaero.map.world.MapWorld;

public class MapDimension {
    private final MapWorld mapWorld;
    private final class_5321<class_1937> dimId;
    private final List<String> multiworldIds;
    private final Hashtable<String, String> multiworldNames;
    private final Hashtable<String, String> autoMultiworldBindings;
    private final DimensionHighlighterHandler highlightHandler;
    private String futureAutoMultiworldBinding;
    private String futureCustomSelectedMultiworld;
    public boolean futureMultiworldWritable;
    public boolean futureMultiworldServerBased;
    private String currentMultiworld;
    public boolean currentMultiworldWritable;
    private String confirmedMultiworld;
    private LeveledRegionManager mapRegions;
    private List<MapRegion> regionBackCompList;
    private Hashtable<Integer, Hashtable<Integer, RegionDetection>> detectedRegions;
    public final ArrayList<LeveledRegion<?>> regionsToCache;

    public MapDimension(MapWorld mapWorld, class_5321<class_1937> dimId, HighlighterRegistry highlighterRegistry) {
        this.mapWorld = mapWorld;
        this.dimId = dimId;
        this.multiworldIds = new ArrayList<String>();
        this.multiworldNames = new Hashtable();
        this.mapRegions = new LeveledRegionManager();
        this.autoMultiworldBindings = new Hashtable();
        this.regionsToCache = new ArrayList();
        this.regionBackCompList = new ArrayList<MapRegion>();
        this.highlightHandler = new DimensionHighlighterHandler(this, dimId, highlighterRegistry);
    }

    public String getCurrentMultiworld() {
        return this.currentMultiworld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMultiworldIdsCopy() {
        List<String> list = this.multiworldIds;
        synchronized (list) {
            return new ArrayList<String>(this.multiworldIds);
        }
    }

    public void updateFutureAutomaticUnsynced(class_310 mc, Object baseObject) {
        if (mc.method_1576() != null) {
            this.futureAutoMultiworldBinding = "";
        } else if (baseObject != null) {
            if (baseObject instanceof class_2338) {
                class_2338 dimSpawn = (class_2338)baseObject;
                this.futureAutoMultiworldBinding = "mw" + (dimSpawn.method_10263() >> 6) + "," + (dimSpawn.method_10264() >> 6) + "," + (dimSpawn.method_10260() >> 6);
                this.futureMultiworldServerBased = false;
            } else if (baseObject instanceof Integer) {
                int levelId = (Integer)baseObject;
                this.futureAutoMultiworldBinding = "mw$" + levelId;
                this.futureCustomSelectedMultiworld = null;
                this.futureMultiworldWritable = true;
                this.futureMultiworldServerBased = true;
            }
        } else {
            this.futureAutoMultiworldBinding = "unknown";
        }
    }

    public String getFutureCustomSelectedMultiworld() {
        return this.futureCustomSelectedMultiworld;
    }

    public String getFutureMultiworldUnsynced() {
        if (this.futureCustomSelectedMultiworld == null) {
            return this.getFutureAutoMultiworld();
        }
        return this.futureCustomSelectedMultiworld;
    }

    public void switchToFutureUnsynced() {
        this.currentMultiworld = this.getFutureMultiworldUnsynced();
        this.addMultiworldChecked(this.currentMultiworld);
    }

    public void switchToFutureMultiworldWritableValueUnsynced() {
        this.currentMultiworldWritable = this.futureMultiworldWritable;
    }

    public LeveledRegionManager getMapRegions() {
        return this.mapRegions;
    }

    @Deprecated
    public List<MapRegion> getMapRegionsList() {
        return this.regionBackCompList;
    }

    public Hashtable<Integer, Hashtable<Integer, RegionDetection>> getDetectedRegions() {
        return this.detectedRegions;
    }

    public Hashtable<Integer, Hashtable<Integer, RegionDetection>> createDetectedRegions() {
        if (this.detectedRegions == null) {
            this.detectedRegions = new Hashtable();
        }
        return this.detectedRegions;
    }

    public void clear() {
        this.mapRegions.clear();
        this.regionBackCompList.clear();
        this.detectedRegions = null;
        this.highlightHandler.onDimensionClear();
    }

    public Path getMainFolderPath() {
        return this.mapWorld.getMapProcessor().getMapSaveLoad().getMainFolder(this.mapWorld.getMainId(), this.mapWorld.getMapProcessor().getDimensionName(this.dimId));
    }

    public Path getOldFolderPath() {
        return this.mapWorld.getMapProcessor().getMapSaveLoad().getOldFolder(this.mapWorld.getOldUnfixedMainId(), this.mapWorld.getMapProcessor().getDimensionName(this.dimId));
    }

    public void saveConfigUnsynced() {
        Path dimensionSavePath = this.getMainFolderPath();
        try (BufferedOutputStream bufferedOutput = new BufferedOutputStream(new FileOutputStream(dimensionSavePath.resolve("dimension_config.txt").toFile()));
             PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutput, StandardCharsets.UTF_8));){
            if (this.mapWorld.isMultiplayer()) {
                if (this.confirmedMultiworld != null) {
                    writer.println("confirmedMultiworld:" + this.confirmedMultiworld);
                }
                for (Map.Entry<String, String> bindingEntry : this.autoMultiworldBindings.entrySet()) {
                    writer.println("autoMWBinding:" + bindingEntry.getKey() + ":" + bindingEntry.getValue());
                }
                for (Map.Entry<String, String> bindingEntry : this.multiworldNames.entrySet()) {
                    writer.println("MWName:" + bindingEntry.getKey() + ":" + bindingEntry.getValue().replace(":", "^col^"));
                }
            }
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigUnsynced() {
        Path dimensionSavePath = this.getMainFolderPath();
        BufferedReader reader = null;
        try {
            Path oldDimensionSavePath = this.getOldFolderPath();
            if (!Files.exists(dimensionSavePath, new LinkOption[0]) && Files.exists(oldDimensionSavePath, new LinkOption[0])) {
                Files.move(oldDimensionSavePath, dimensionSavePath, new CopyOption[0]);
            }
            if (!Files.exists(dimensionSavePath, new LinkOption[0])) {
                Files.createDirectories(dimensionSavePath, new FileAttribute[0]);
            }
            this.loadMultiworldsList(dimensionSavePath);
            Path configFile = dimensionSavePath.resolve("dimension_config.txt");
            if (Files.exists(configFile, new LinkOption[0])) {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile.toFile()), "UTF8"));
                while ((line = reader.readLine()) != null) {
                    String[] args = line.split(":");
                    if (!this.mapWorld.isMultiplayer()) continue;
                    if (args[0].equals("confirmedMultiworld")) {
                        if (!this.multiworldIds.contains(args[1])) continue;
                        this.confirmedMultiworld = args[1];
                        continue;
                    }
                    if (args[0].equals("autoMWBinding")) {
                        this.bindAutoMultiworld(args[1], args[2]);
                        continue;
                    }
                    if (!args[0].equals("MWName")) continue;
                    this.setMultiworldName(args[1], args[2].replace("^col^", ":"));
                }
            } else {
                this.saveConfigUnsynced();
            }
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
        }
    }

    public void pickDefaultCustomMultiworldUnsynced() {
        if (this.multiworldIds.isEmpty()) {
            this.futureCustomSelectedMultiworld = "mw$default";
            this.multiworldIds.add(this.futureCustomSelectedMultiworld);
            this.setMultiworldName(this.futureCustomSelectedMultiworld, "Default");
        } else {
            int indexOfAuto = this.multiworldIds.indexOf(this.getFutureAutoMultiworld());
            this.futureCustomSelectedMultiworld = this.multiworldIds.get(indexOfAuto != -1 ? indexOfAuto : 0);
        }
    }

    private void loadMultiworldsList(Path dimensionSavePath) {
        if (!this.mapWorld.isMultiplayer()) {
            return;
        }
        try {
            Stream<Path> subFolders = Files.list(dimensionSavePath);
            Iterator iter = subFolders.iterator();
            while (iter.hasNext()) {
                Path path = (Path)iter.next();
                if (!path.toFile().isDirectory()) continue;
                String folderName = path.getFileName().toString();
                boolean autoMultiworldFormat = folderName.matches("^mw(-?\\d+),(-?\\d+),(-?\\d+)$");
                boolean levelIdMultiworldFormat = folderName.startsWith("mw$");
                boolean customMultiworldFormat = folderName.startsWith("cm$");
                if (!autoMultiworldFormat && !levelIdMultiworldFormat && !customMultiworldFormat) continue;
                this.multiworldIds.add(folderName);
            }
            subFolders.close();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public void confirmMultiworldUnsynced() {
        if (!this.futureMultiworldWritable) {
            this.futureMultiworldWritable = true;
            if (this.mapWorld.getFutureMultiworldType(this) == 2 && this.futureCustomSelectedMultiworld != null) {
                this.makeCustomSelectedMultiworldAuto();
            }
            this.confirmedMultiworld = this.getFutureMultiworldUnsynced();
            this.saveConfigUnsynced();
        }
    }

    private void makeCustomSelectedMultiworldAuto() {
        String currentAutoMultiworld = this.getFutureAutoMultiworld();
        boolean currentBindingFound = false;
        for (Map.Entry<String, String> bindingEntry : this.autoMultiworldBindings.entrySet()) {
            if (!bindingEntry.getValue().equals(this.futureCustomSelectedMultiworld)) continue;
            this.bindAutoMultiworld(bindingEntry.getKey(), currentAutoMultiworld);
            currentBindingFound = true;
            break;
        }
        if (!currentBindingFound && !this.futureCustomSelectedMultiworld.startsWith("cm$")) {
            this.bindAutoMultiworld(this.futureCustomSelectedMultiworld, currentAutoMultiworld);
        }
        this.bindAutoMultiworld(this.futureAutoMultiworldBinding, this.futureCustomSelectedMultiworld);
        this.futureCustomSelectedMultiworld = null;
        this.saveConfigUnsynced();
    }

    private void bindAutoMultiworld(String binding, String multiworld) {
        if (binding.equals(multiworld)) {
            this.autoMultiworldBindings.remove(binding);
        } else {
            this.autoMultiworldBindings.put(binding, multiworld);
        }
    }

    public void resetCustomMultiworldUnsynced() {
        String string = this.futureCustomSelectedMultiworld = this.mapWorld.getFutureMultiworldType(this) == 2 ? null : this.confirmedMultiworld;
        if (this.futureCustomSelectedMultiworld == null && this.mapWorld.getFutureMultiworldType(this) < 2) {
            this.pickDefaultCustomMultiworldUnsynced();
        }
        this.futureMultiworldWritable = this.mapWorld.getFutureMultiworldType(this) != 1 && this.mapWorld.isFutureMultiworldTypeConfirmed(this);
    }

    public void setMultiworldUnsynced(String nextMW) {
        String cmw = this.futureCustomSelectedMultiworld == null ? this.getFutureMultiworldUnsynced() : this.futureCustomSelectedMultiworld;
        this.futureCustomSelectedMultiworld = nextMW;
        this.futureMultiworldWritable = false;
        WorldMap.LOGGER.info(cmw + " -> " + this.futureCustomSelectedMultiworld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean multiworldExists(String mw) {
        List<String> list = this.multiworldIds;
        synchronized (list) {
            return this.multiworldIds.contains(mw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMultiworldChecked(String mw) {
        List<String> list = this.multiworldIds;
        synchronized (list) {
            if (!this.multiworldIds.contains(mw)) {
                this.multiworldIds.add(mw);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldName(String mwId) {
        String tableName = this.multiworldNames.get(mwId);
        if (tableName == null) {
            if (this.multiworldExists(mwId)) {
                String automaticName;
                int index = 1;
                while (this.multiworldNames.containsValue(automaticName = "Map " + index++)) {
                }
                this.setMultiworldName(mwId, automaticName);
                Object object = this.mapWorld.getMapProcessor().uiSync;
                synchronized (object) {
                    this.saveConfigUnsynced();
                }
                return automaticName;
            }
            return mwId;
        }
        return tableName;
    }

    public void setMultiworldName(String mwId, String mwName) {
        this.multiworldNames.put(mwId, mwName);
    }

    private String getFutureAutoMultiworld() {
        if (this.futureAutoMultiworldBinding == null) {
            return null;
        }
        String boundMultiworld = this.autoMultiworldBindings.get(this.futureAutoMultiworldBinding);
        if (boundMultiworld == null) {
            return this.futureAutoMultiworldBinding;
        }
        return boundMultiworld;
    }

    public MapWorld getMapWorld() {
        return this.mapWorld;
    }

    public void deleteMultiworldMapDataUnsynced(String mwId) {
        try {
            Path currentDimFolder = this.getMainFolderPath();
            Path currentMWFolder = currentDimFolder.resolve(mwId);
            Path binFolder = currentDimFolder.resolve("last deleted");
            Path binMWFolder = binFolder.resolve(mwId);
            if (!Files.exists(binFolder, new LinkOption[0])) {
                Files.createDirectories(binFolder, new FileAttribute[0]);
            }
            FileUtils.cleanDirectory((File)binFolder.toFile());
            Files.move(currentMWFolder, binMWFolder, new CopyOption[0]);
        }
        catch (Exception e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMultiworldId(String mwId) {
        List<String> list = this.multiworldIds;
        synchronized (list) {
            this.multiworldIds.remove(mwId);
            this.multiworldNames.remove(mwId);
            if (mwId.equals(this.confirmedMultiworld)) {
                this.confirmedMultiworld = null;
            }
        }
    }

    public class_5321<class_1937> getDimId() {
        return this.dimId;
    }

    public boolean hasConfirmedMultiworld() {
        return this.confirmedMultiworld != null;
    }

    public boolean isFutureMultiworldServerBased() {
        return this.futureMultiworldServerBased;
    }

    public DimensionHighlighterHandler getHighlightHandler() {
        return this.highlightHandler;
    }
}

