/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.impl;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl.api.ListOption;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public final class OptionGroupImpl
implements OptionGroup {
    @NotNull
    private final class_2561 name;
    @NotNull
    private final class_2561 tooltip;
    private final ImmutableList<? extends Option<?>> options;
    private final boolean collapsed;
    private final boolean isRoot;

    public OptionGroupImpl(@NotNull class_2561 name, @NotNull class_2561 tooltip, ImmutableList<? extends Option<?>> options, boolean collapsed, boolean isRoot) {
        this.name = name;
        this.tooltip = tooltip;
        this.options = options;
        this.collapsed = collapsed;
        this.isRoot = isRoot;
    }

    @Override
    @NotNull
    public class_2561 name() {
        return this.name;
    }

    @Override
    @NotNull
    public class_2561 tooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public ImmutableList<? extends Option<?>> options() {
        return this.options;
    }

    @Override
    public boolean collapsed() {
        return this.collapsed;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.Internal
    public static final class BuilderImpl
    implements OptionGroup.Builder {
        private class_2561 name = class_2561.method_43473();
        private final List<class_2561> tooltipLines = new ArrayList<class_2561>();
        private final List<Option<?>> options = new ArrayList();
        private boolean collapsed = false;

        @Override
        public OptionGroup.Builder name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` must not be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @Override
        public OptionGroup.Builder tooltip(class_2561 ... tooltips) {
            Validate.notEmpty((Object[])tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipLines.addAll(List.of(tooltips));
            return this;
        }

        @Override
        public OptionGroup.Builder option(@NotNull Option<?> option) {
            Validate.notNull(option, (String)"`option` must not be null", (Object[])new Object[0]);
            if (option instanceof ListOption) {
                throw new UnsupportedOperationException("List options must not be added as an option but a group!");
            }
            this.options.add(option);
            return this;
        }

        @Override
        public OptionGroup.Builder options(@NotNull Collection<? extends Option<?>> options) {
            Validate.notEmpty(options, (String)"`options` must not be empty", (Object[])new Object[0]);
            if (options.stream().anyMatch(ListOption.class::isInstance)) {
                throw new UnsupportedOperationException("List options must not be added as an option but a group!");
            }
            this.options.addAll(options);
            return this;
        }

        @Override
        public OptionGroup.Builder collapsed(boolean collapsible) {
            this.collapsed = collapsible;
            return this;
        }

        @Override
        public OptionGroup build() {
            Validate.notEmpty(this.options, (String)"`options` must not be empty to build `OptionGroup`", (Object[])new Object[0]);
            class_5250 concatenatedTooltip = class_2561.method_43473();
            boolean first = true;
            for (class_2561 line : this.tooltipLines) {
                if (!first) {
                    concatenatedTooltip.method_27693("\n");
                }
                first = false;
                concatenatedTooltip.method_10852(line);
            }
            return new OptionGroupImpl(this.name, (class_2561)concatenatedTooltip, ImmutableList.copyOf(this.options), this.collapsed, false);
        }
    }
}

