/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.codedsakura.blossom.lib.BlossomGlobals;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public abstract class DataController<T> {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    protected T data = null;
    private MinecraftServer server;

    public DataController() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
            this.data = this.read(server);
            if (this.data == null) {
                this.data = this.defaultData();
            }
            this.write(server);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(this::write);
    }

    public abstract T defaultData();

    public abstract String getFilename();

    protected Class<T> getType() {
        return this.defaultData().getClass();
    }

    protected T readJson(InputStreamReader reader) {
        return (T)GSON.fromJson((Reader)new BufferedReader(reader), this.getType());
    }

    protected void writeJson(OutputStreamWriter writer) {
        GSON.toJson(this.data, (Appendable)writer);
    }

    private File getFile(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("data").resolve(this.getFilename() + ".json").toFile();
    }

    private InputStreamReader getReader(MinecraftServer server) throws FileNotFoundException {
        return new InputStreamReader(new FileInputStream(this.getFile(server)));
    }

    private OutputStreamWriter getWriter(MinecraftServer server) throws FileNotFoundException {
        return new OutputStreamWriter(new FileOutputStream(this.getFile(server)));
    }

    public void write() {
        this.write(this.server);
    }

    public void write(MinecraftServer server) {
        BlossomGlobals.LOGGER.trace("writing");
        try {
            OutputStreamWriter writer = this.getWriter(server);
            this.writeJson(writer);
            writer.close();
        }
        catch (Exception e) {
            BlossomGlobals.LOGGER.throwing((Throwable)e);
        }
    }

    public T read() {
        return this.read(this.server);
    }

    public T read(MinecraftServer server) {
        BlossomGlobals.LOGGER.trace("reading");
        try {
            return this.readJson(this.getReader(server));
        }
        catch (Exception e) {
            BlossomGlobals.LOGGER.info(e.getMessage());
            return null;
        }
    }
}

