/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.math2d.Point;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\r\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b>\u0010?B'\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u0012\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b>\u0010@J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0004\b\u000b\u0010\u000fJ8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0012\u0010\u0017J\u001a\u0010\u0019\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0004J\u0015\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b \u0010!J\u0010\u0010#\u001a\u00020\"H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0004R\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010+\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0017\u0010\u0011\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010,\u001a\u0004\b-\u0010\u0004R\u0011\u0010/\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0004R\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010(R\u0011\u00102\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0004R\u0011\u0010\u0016\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00106\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0004R\u0011\u00108\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010(R\u0011\u0010:\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010(R\u0017\u0010\u0010\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010,\u001a\u0004\b;\u0010\u0004R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010,\u001a\u0004\b<\u0010\u0004R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010,\u001a\u0004\b=\u0010\u0004\u00a8\u0006A"}, d2={"Lorg/anti_ad/mc/common/math2d/Rectangle;", "", "", "component1", "()I", "component2", "component3", "component4", "x", "y", "", "contains", "(II)Z", "Lorg/anti_ad/mc/common/math2d/Point;", "point", "(Lorg/anti_ad/mc/common/math2d/Point;)Z", "width", "height", "copy", "(IIII)Lorg/anti_ad/mc/common/math2d/Rectangle;", "location", "Lorg/anti_ad/mc/common/math2d/Size;", "size", "(Lorg/anti_ad/mc/common/math2d/Point;Lorg/anti_ad/mc/common/math2d/Size;)Lorg/anti_ad/mc/common/math2d/Rectangle;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "amount", "inflated", "(I)Lorg/anti_ad/mc/common/math2d/Rectangle;", "parent", "insideOf", "(Lorg/anti_ad/mc/common/math2d/Rectangle;)Z", "", "toString", "()Ljava/lang/String;", "getBottom", "bottom", "getBottomLeft", "()Lorg/anti_ad/mc/common/math2d/Point;", "bottomLeft", "getBottomRight", "bottomRight", "I", "getHeight", "getLeft", "left", "getLocation", "getRight", "right", "getSize", "()Lorg/anti_ad/mc/common/math2d/Size;", "getTop", "top", "getTopLeft", "topLeft", "getTopRight", "topRight", "getWidth", "getX", "getY", "<init>", "(Lorg/anti_ad/mc/common/math2d/Point;Lorg/anti_ad/mc/common/math2d/Size;)V", "(IIII)V", "libIPN"})
public final class Rectangle {
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public Rectangle(@NotNull Point location, @NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this(location.getX(), location.getY(), size.getWidth(), size.getHeight());
    }

    public final int getLeft() {
        return this.x;
    }

    public final int getTop() {
        return this.y;
    }

    public final int getRight() {
        return this.x + this.width;
    }

    public final int getBottom() {
        return this.y + this.height;
    }

    @NotNull
    public final Point getTopLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Point getTopRight() {
        return new Point(this.getRight(), this.getTop());
    }

    @NotNull
    public final Point getBottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Point getBottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    @NotNull
    public final Point getLocation() {
        return new Point(this.x, this.y);
    }

    @NotNull
    public final Size getSize() {
        return new Size(this.width, this.height);
    }

    @NotNull
    public final Rectangle copy(@NotNull Point location, @NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return new Rectangle(location, size);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, Point point, Size size, int n, Object object) {
        if ((n & 1) != 0) {
            point = rectangle.getLocation();
        }
        if ((n & 2) != 0) {
            size = rectangle.getSize();
        }
        return rectangle.copy(point, size);
    }

    @NotNull
    public final Rectangle inflated(int amount) {
        return new Rectangle(this.x - amount, this.y - amount, this.width + amount * 2, this.height + amount * 2);
    }

    public final boolean contains(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.contains(point.getX(), point.getY());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(int x, int y) {
        int n = this.getLeft();
        if (x >= this.getRight()) return false;
        if (n > x) return false;
        boolean bl = true;
        if (!bl) return false;
        n = this.getTop();
        if (y >= this.getBottom()) return false;
        if (n > y) return false;
        return true;
    }

    public final boolean insideOf(@Nullable Rectangle parent) {
        if (parent != null) {
            if (this.x < parent.x) {
                return false;
            }
            if (this.y < parent.y) {
                return false;
            }
            if (this.x + this.width > parent.x + parent.width) {
                return false;
            }
            if (this.y + this.height > parent.y + parent.height) {
                return false;
            }
        }
        return true;
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @NotNull
    public final Rectangle copy(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = rectangle.x;
        }
        if ((n5 & 2) != 0) {
            n2 = rectangle.y;
        }
        if ((n5 & 4) != 0) {
            n3 = rectangle.width;
        }
        if ((n5 & 8) != 0) {
            n4 = rectangle.height;
        }
        return rectangle.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "Rectangle(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        result = result * 31 + Integer.hashCode(this.width);
        result = result * 31 + Integer.hashCode(this.height);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)other;
        if (this.x != rectangle.x) {
            return false;
        }
        if (this.y != rectangle.y) {
            return false;
        }
        if (this.width != rectangle.width) {
            return false;
        }
        return this.height == rectangle.height;
    }
}

