/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave.biome;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.file.worldsave.biome.WorldDataReaderSectionBiomeData;

public class WorldDataReaderChunkBiomeData {
    private Int2ObjectMap<WorldDataReaderSectionBiomeData> sections;

    public void addSection(int sectionIndex, WorldDataReaderSectionBiomeData section) {
        if (this.sections == null) {
            this.sections = new Int2ObjectOpenHashMap();
        }
        this.sections.put(sectionIndex, (Object)section);
    }

    public BiomeKey getNoiseBiomeKey(int quadX, int quadY, int quadZ, BiomeKeyManager biomeKeyManager) {
        if (this.sections == null) {
            return null;
        }
        int sectionIndex = quadY >> 2;
        WorldDataReaderSectionBiomeData section = (WorldDataReaderSectionBiomeData)this.sections.get(sectionIndex);
        if (section == null) {
            return null;
        }
        int sectionQuadY = quadY & 3;
        String biomeString = section.get(quadX, sectionQuadY, quadZ);
        if (biomeString == null) {
            return null;
        }
        return biomeKeyManager.get(biomeString);
    }

    public void clear() {
        this.sections = null;
    }
}

