/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.back;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.codedsakura.blossom.back.BlossomBackConfig;
import dev.codedsakura.blossom.back.BlossomLastDeath;
import dev.codedsakura.blossom.lib.BlossomLib;
import dev.codedsakura.blossom.lib.config.ConfigManager;
import dev.codedsakura.blossom.lib.permissions.Permissions;
import dev.codedsakura.blossom.lib.teleport.TeleportConfig;
import dev.codedsakura.blossom.lib.teleport.TeleportUtils;
import dev.codedsakura.blossom.lib.text.TextUtils;
import dev.codedsakura.blossom.lib.utils.CustomLogger;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import org.apache.logging.log4j.core.Logger;

public class BlossomBack
implements ModInitializer {
    static BlossomBackConfig CONFIG = (BlossomBackConfig)ConfigManager.register(BlossomBackConfig.class, (String)"BlossomBack.json", newConfig -> {
        CONFIG = newConfig;
    });
    public static final Logger LOGGER = CustomLogger.createLogger((String)"BlossomBack");
    public static HashMap<UUID, TeleportUtils.TeleportDestination> deaths = new HashMap();

    public void onInitialize() {
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires(Permissions.require((String)"blossom.back", (boolean)true))).executes(this::runBack)));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lastdeath").requires(Permissions.require((String)"blossom.last-death", (boolean)false))).executes(this::runLastDeath)));
    }

    private int runBack(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        TeleportUtils.TeleportDestination destination = TeleportUtils.getLastTeleport((UUID)player.method_5667());
        LOGGER.trace("back {} ({}) to {}", (Object)player.method_5820(), (Object)player.method_5667(), (Object)destination);
        if (destination != null) {
            TeleportUtils.teleport((TeleportConfig)BlossomBack.CONFIG.back.teleportation, (double)BlossomBack.CONFIG.back.standStill, (long)BlossomBack.CONFIG.back.cooldown, BlossomBack.class, (class_3222)player, () -> destination);
        } else {
            TextUtils.sendErr(ctx, (String)"blossom.back.error.no-previous", (Object[])new Object[0]);
        }
        return 1;
    }

    private int runLastDeath(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        boolean joinedConfig;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        TeleportUtils.TeleportDestination destination = deaths.get(player.method_5667());
        LOGGER.trace("back {} ({}) to {}", (Object)player.method_5820(), (Object)player.method_5667(), (Object)destination);
        boolean bl = joinedConfig = BlossomBack.CONFIG.lastDeath == null;
        if (destination != null) {
            TeleportUtils.teleport((TeleportConfig)(joinedConfig ? BlossomBack.CONFIG.back.teleportation : BlossomBack.CONFIG.lastDeath.teleportation), (double)(joinedConfig ? (double)BlossomBack.CONFIG.back.standStill : (double)BlossomBack.CONFIG.lastDeath.standStill), (long)(joinedConfig ? (long)BlossomBack.CONFIG.back.cooldown : (long)BlossomBack.CONFIG.lastDeath.cooldown), joinedConfig ? BlossomBack.class : BlossomLastDeath.class, (class_3222)player, () -> destination);
        } else {
            TextUtils.sendErr(ctx, (String)"blossom.back.error.no-death", (Object[])new Object[0]);
        }
        return 1;
    }
}

