/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.opus;

import de.maxhenkel.opus4j.OpusEncoder;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusDecoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusEncoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.NativeOpusDecoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.NativeOpusEncoderImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;

public class OpusManager {
    private static boolean nativeOpusCompatible = true;

    public static boolean opusNativeCheck() {
        Voicechat.LOGGER.info("Loading Opus");
        if (!nativeOpusCompatible || !OpusManager.useNatives()) {
            return false;
        }
        Boolean success = Utils.createSafe(() -> {
            NativeOpusEncoderImpl encoder = new NativeOpusEncoderImpl(48000, 1, OpusEncoder.Application.VOIP);
            encoder.setMaxPayloadSize(1024);
            byte[] encoded = encoder.encode(new short[960]);
            encoder.resetState();
            encoder.close();
            NativeOpusDecoderImpl decoder = new NativeOpusDecoderImpl(48000, 1);
            decoder.setFrameSize(960);
            decoder.decode(encoded);
            decoder.decodeFec();
            decoder.resetState();
            decoder.close();
            return true;
        }, e -> Voicechat.LOGGER.warn("Failed to load native Opus implementation", e));
        if (success == null || !success.booleanValue()) {
            Voicechat.LOGGER.warn("Failed to load native Opus encoder - Falling back to Java Opus implementation");
            nativeOpusCompatible = false;
            return false;
        }
        return true;
    }

    @Nullable
    private static OpusEncoder createNativeEncoder(int mtuSize, OpusEncoder.Application application) {
        if (!nativeOpusCompatible) {
            return null;
        }
        try {
            NativeOpusEncoderImpl encoder = new NativeOpusEncoderImpl(48000, 1, application);
            encoder.setMaxPayloadSize(mtuSize);
            return encoder;
        }
        catch (Throwable e) {
            nativeOpusCompatible = false;
            Voicechat.LOGGER.warn("Failed to load native Opus encoder - Falling back to Java Opus implementation");
            return null;
        }
    }

    public static OpusEncoder createEncoder(OpusEncoderMode mode) {
        OpusEncoder encoder;
        ClientVoicechatConnection connection;
        ClientVoicechat client;
        int mtuSize = 1024;
        if (!CommonCompatibilityManager.INSTANCE.isDedicatedServer() && (client = ClientManager.getClient()) != null && (connection = client.getConnection()) != null) {
            mtuSize = connection.getData().getMtuSize();
        }
        OpusEncoder.Application application = OpusEncoder.Application.VOIP;
        if (mode != null) {
            switch (mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case VOIP: {
                    OpusEncoder.Application application2 = OpusEncoder.Application.VOIP;
                    break;
                }
                case AUDIO: {
                    OpusEncoder.Application application2 = OpusEncoder.Application.AUDIO;
                    break;
                }
                case RESTRICTED_LOWDELAY: {
                    OpusEncoder.Application application2 = application = OpusEncoder.Application.LOW_DELAY;
                }
            }
        }
        if (OpusManager.useNatives() && (encoder = OpusManager.createNativeEncoder(mtuSize, application)) != null) {
            return encoder;
        }
        return new JavaOpusEncoderImpl(48000, 960, mtuSize, application);
    }

    @Nullable
    private static OpusDecoder createNativeDecoder() {
        if (!nativeOpusCompatible) {
            return null;
        }
        try {
            NativeOpusDecoderImpl decoder = new NativeOpusDecoderImpl(48000, 1);
            decoder.setFrameSize(960);
            return decoder;
        }
        catch (Throwable e) {
            nativeOpusCompatible = false;
            Voicechat.LOGGER.warn("Failed to load native Opus decoder - Falling back to Java Opus implementation");
            return null;
        }
    }

    public static OpusDecoder createDecoder() {
        OpusDecoder decoder;
        if (OpusManager.useNatives() && (decoder = OpusManager.createNativeDecoder()) != null) {
            return decoder;
        }
        return new JavaOpusDecoderImpl(48000, 960);
    }

    public static boolean useNatives() {
        if (VoicechatClient.CLIENT_CONFIG == null) {
            return true;
        }
        return VoicechatClient.CLIENT_CONFIG.useNatives.get();
    }
}

