/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.tpa;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.codedsakura.blossom.lib.BlossomLib;
import dev.codedsakura.blossom.lib.config.ConfigManager;
import dev.codedsakura.blossom.lib.permissions.Permissions;
import dev.codedsakura.blossom.lib.teleport.TeleportConfig;
import dev.codedsakura.blossom.lib.teleport.TeleportUtils;
import dev.codedsakura.blossom.lib.text.TextUtils;
import dev.codedsakura.blossom.lib.utils.CustomLogger;
import dev.codedsakura.blossom.tpa.BlossomTpaConfig;
import dev.codedsakura.blossom.tpa.TpaRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.logging.log4j.core.Logger;

public class BlossomTpa
implements ModInitializer {
    static BlossomTpaConfig CONFIG = (BlossomTpaConfig)ConfigManager.register(BlossomTpaConfig.class, (String)"BlossomTpa.json", newConfig -> {
        CONFIG = newConfig;
    });
    public static final Logger LOGGER = CustomLogger.createLogger((String)"BlossomTpa");
    private final ArrayList<TpaRequest> activeTpas = new ArrayList();

    public void onInitialize() {
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").requires(Permissions.require((String)"blossom.tpa", (boolean)true))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::runTpaTo))));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").requires(Permissions.require((String)"blossom.tpa.here", (boolean)true))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::runTpaHere))));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaaccept").requires(Permissions.require((String)"blossom.tpa", (boolean)true))).executes(this::acceptTpaAuto)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::acceptTpaTarget))));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpadeny").requires(Permissions.require((String)"blossom.tpa", (boolean)true))).executes(this::denyTpaAuto)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::denyTpaTarget))));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpacancel").requires(Permissions.require((String)"blossom.tpa", (boolean)true))).executes(this::cancelTpaAuto)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::cancelTpaTarget))));
    }

    private int runTpa(CommandContext<class_2168> ctx, boolean tpaHere) throws CommandSyntaxException {
        class_3222 receiver;
        class_3222 initiator = ((class_2168)ctx.getSource()).method_9207();
        if (initiator.equals((Object)(receiver = class_2186.method_9315(ctx, (String)"target")))) {
            TextUtils.sendErr(ctx, (String)"blossom.tpa.fail.to-self", (Object[])new Object[0]);
            return 1;
        }
        if (Permissions.check((class_1297)receiver, (String)"blossom.tpa.disallowed", (boolean)false)) {
            TextUtils.sendErr(ctx, (String)"blossom.tpa.fail.disallowed", (Object[])new Object[]{receiver});
            return 1;
        }
        TpaRequest tpaRequest = new TpaRequest(initiator, receiver, tpaHere);
        if (this.activeTpas.stream().anyMatch(tpaRequest::similarTo)) {
            TextUtils.sendErr(ctx, (String)"blossom.tpa.fail.similar", (Object[])new Object[]{receiver});
            return 1;
        }
        tpaRequest.startTimeout(() -> this.activeTpas.remove(tpaRequest));
        this.activeTpas.add(tpaRequest);
        return 1;
    }

    private int runTpaTo(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.runTpa(ctx, false);
    }

    private int runTpaHere(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.runTpa(ctx, true);
    }

    private int resolveTpa(CommandContext<class_2168> ctx, class_3222 receiver, class_3222 initiator, ResolveState resolveState) {
        Optional<TpaRequest> tpaRequestOptional = this.activeTpas.stream().filter(request -> request.receiver.equals((Object)receiver) && request.initiator.equals((Object)initiator)).findFirst();
        if (tpaRequestOptional.isEmpty()) {
            if (resolveState == ResolveState.CANCEL) {
                TextUtils.sendErr(ctx, (String)"blossom.tpa.fail.cancel.none-to", (Object[])new Object[]{receiver});
            } else {
                TextUtils.sendErr(ctx, (String)"blossom.tpa.fail.none-from", (Object[])new Object[]{initiator});
            }
            return 1;
        }
        TpaRequest tpaRequest = tpaRequestOptional.get();
        if (resolveState == ResolveState.ACCEPT) {
            TeleportUtils.teleport((TeleportConfig)BlossomTpa.CONFIG.teleportation, (double)BlossomTpa.CONFIG.standStill, (long)BlossomTpa.CONFIG.cooldown, BlossomTpa.class, (class_3222)tpaRequest.teleportWho, () -> new TeleportUtils.TeleportDestination((class_1657)tpaRequest.teleportTo));
        }
        String localeRoot = "blossom.tpa." + (tpaRequest.tpaHere ? "here." : "to.") + resolveState.toString().toLowerCase();
        tpaRequest.initiator.method_7353((class_2561)TextUtils.translation((String)(localeRoot + ".initiator"), (Object[])tpaRequest.toArgs()), false);
        tpaRequest.receiver.method_7353((class_2561)TextUtils.translation((String)(localeRoot + ".receiver"), (Object[])tpaRequest.toArgs()), false);
        tpaRequest.cancelTimeout();
        this.activeTpas.remove(tpaRequest);
        return 1;
    }

    private int resolveTpaAuto(CommandContext<class_2168> ctx, ResolveState resolveState) {
        List<TpaRequest> candidates;
        if (resolveState == ResolveState.CANCEL) {
            class_3222 initiator = ((class_2168)ctx.getSource()).method_44023();
            candidates = this.activeTpas.stream().filter(request -> request.initiator.equals((Object)initiator)).toList();
        } else {
            class_3222 receiver = ((class_2168)ctx.getSource()).method_44023();
            candidates = this.activeTpas.stream().filter(request -> request.receiver.equals((Object)receiver)).toList();
        }
        if (candidates.size() > 1) {
            TextUtils.sendErr(ctx, (String)"blossom.tpa.fail.multiple", (Object[])new Object[0]);
            return 1;
        }
        if (candidates.size() < 1) {
            TextUtils.sendErr(ctx, (String)"blossom.tpa.fail.none", (Object[])new Object[0]);
            return 1;
        }
        return this.resolveTpa(ctx, candidates.get((int)0).receiver, candidates.get((int)0).initiator, resolveState);
    }

    private int acceptTpaAuto(CommandContext<class_2168> ctx) {
        return this.resolveTpaAuto(ctx, ResolveState.ACCEPT);
    }

    private int acceptTpaTarget(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 receiver = ((class_2168)ctx.getSource()).method_44023();
        class_3222 initiator = class_2186.method_9315(ctx, (String)"target");
        return this.resolveTpa(ctx, receiver, initiator, ResolveState.ACCEPT);
    }

    private int denyTpaAuto(CommandContext<class_2168> ctx) {
        return this.resolveTpaAuto(ctx, ResolveState.DENY);
    }

    private int denyTpaTarget(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 receiver = ((class_2168)ctx.getSource()).method_44023();
        class_3222 initiator = class_2186.method_9315(ctx, (String)"target");
        return this.resolveTpa(ctx, receiver, initiator, ResolveState.DENY);
    }

    private int cancelTpaAuto(CommandContext<class_2168> ctx) {
        return this.resolveTpaAuto(ctx, ResolveState.CANCEL);
    }

    private int cancelTpaTarget(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 receiver = class_2186.method_9315(ctx, (String)"target");
        class_3222 initiator = ((class_2168)ctx.getSource()).method_44023();
        return this.resolveTpa(ctx, receiver, initiator, ResolveState.CANCEL);
    }

    private static enum ResolveState {
        ACCEPT,
        DENY,
        CANCEL;

    }
}

