/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.functions;

import com.mojang.datafixers.FunctionType;
import com.mojang.datafixers.functions.PointFree;
import com.mojang.datafixers.kinds.App2;
import com.mojang.datafixers.optics.Optic;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.function.Function;

final class ProfunctorTransformer<S, T, A, B>
extends PointFree<Function<Function<A, B>, Function<S, T>>> {
    protected final Optic<? super FunctionType.Instance.Mu, S, T, A, B> optic;
    protected final Type<Function<Function<A, B>, Function<S, T>>> type;

    public ProfunctorTransformer(Optic<? super FunctionType.Instance.Mu, S, T, A, B> optic, Type<Function<Function<A, B>, Function<S, T>>> type) {
        this.optic = optic;
        this.type = type;
    }

    public <S2, T2> ProfunctorTransformer<S2, T2, A, B> castOuterUnchecked(Type<Function<Function<A, B>, Function<S2, T2>>> newType) {
        return new ProfunctorTransformer<S, T, A, B>(this.optic, newType);
    }

    @Override
    public Type<Function<Function<A, B>, Function<S, T>>> type() {
        return this.type;
    }

    @Override
    public String toString(int level) {
        return "Optic[" + this.optic + "]";
    }

    @Override
    public Function<DynamicOps<?>, Function<Function<A, B>, Function<S, T>>> eval() {
        Function func = this.optic.eval(FunctionType.Instance.INSTANCE);
        Function<Function, Function> unwrappedFunction = input -> FunctionType.unbox((App2)func.apply(FunctionType.create(input)));
        return ops -> unwrappedFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfunctorTransformer that = (ProfunctorTransformer)o;
        return Objects.equals(this.optic, that.optic) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return this.optic.hashCode();
    }
}

