/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1159;
import net.minecraft.class_276;
import net.minecraft.class_285;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO;
    private int glEmptyTexture;
    private class_4587 matrixStack = new class_4587();
    private class_1159 projectionMatrix = class_1159.method_34239((float)0.0f, (float)64.0f, (float)0.0f, (float)64.0f, (float)-1.0f, (float)1.0f);

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, class_276 defaultFramebuffer, boolean justAllocated) {
        if (this.renderFBO == null) {
            this.renderFBO = new ImprovedFramebuffer(64, 64, false);
            this.glEmptyTexture = this.renderFBO.getFramebufferTexture();
            this.renderFBO.method_1235(true);
            GlStateManager._disableBlend();
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16384, (boolean)class_310.field_1703);
            GlStateManager._enableBlend();
        }
        GlStateManager._bindTexture((int)0);
        this.renderFBO.method_1235(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        class_4587 shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.method_22903();
        shaderMatrixStack.method_34426();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix((class_1159)this.projectionMatrix);
        GlStateManager._disableBlend();
        if (justAllocated) {
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager._clear((int)16384, (boolean)class_310.field_1703);
        }
        boolean first = true;
        if (srcTextureTopLeft != null) {
            first = this.renderCorner(srcTextureTopLeft, 0, 0, first);
        }
        if (srcTextureTopRight != null) {
            first = this.renderCorner(srcTextureTopRight, 1, 0, first);
        }
        if (srcTextureBottomLeft != null) {
            first = this.renderCorner(srcTextureBottomLeft, 0, 1, first);
        }
        if (srcTextureBottomRight != null) {
            first = this.renderCorner(srcTextureBottomRight, 1, 1, first);
        }
        OpenGLException.checkGLError();
        GlStateManager._enableBlend();
        class_285.method_22094((int)0);
        RenderSystem.setShaderTexture((int)0, (int)0);
        GlStateManager._bindTexture((int)0);
        shaderMatrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_310 mc = class_310.method_1551();
        Misc.minecraftOrtho(mc);
        this.renderFBO.method_1240();
        this.renderFBO.bindDefaultFramebuffer(mc);
        GlStateManager._viewport((int)0, (int)0, (int)mc.method_22683().method_4489(), (int)mc.method_22683().method_4506());
        OpenGLException.checkGLError();
    }

    private boolean renderCorner(Integer srcTexture, int cornerX, int cornerY, boolean first) {
        int texture;
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        int n = texture = srcTexture != -1 ? srcTexture : this.glEmptyTexture;
        if (first) {
            RenderSystem.setShaderTexture((int)0, (int)texture);
        } else {
            GlStateManager._activeTexture((int)33984);
            GlStateManager._bindTexture((int)texture);
        }
        MapRenderHelper.renderBranchUpdate(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f, first);
        return false;
    }
}

