/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import me.jellysquid.mods.lithium.common.world.WorldHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2784;
import org.jetbrains.annotations.NotNull;

public class LithiumEntityCollisions {
    public static final double EPSILON = 1.0E-7;

    public static List<class_265> getBlockCollisions(class_1941 world, class_1297 entity, class_238 box) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box);
        while (sweeper.hasNext()) {
            shapes.add((class_265)sweeper.next());
        }
        return shapes;
    }

    public static boolean doesBoxCollideWithBlocks(class_1941 world, class_1297 entity, class_238 box) {
        ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box);
        class_265 shape = sweeper.computeNext();
        return shape != null && !shape.method_1110();
    }

    public static boolean doesBoxCollideWithHardEntities(class_1924 view, class_1297 entity, class_238 box) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return false;
        }
        return LithiumEntityCollisions.getEntityWorldBorderCollisionIterable(view, entity, box.method_1014(1.0E-7), false).iterator().hasNext();
    }

    public static List<class_265> getEntityWorldBorderCollisions(class_1937 world, class_1297 entity, class_238 box, boolean includeWorldBorder) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return Collections.emptyList();
        }
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        Iterable<class_265> collisions = LithiumEntityCollisions.getEntityWorldBorderCollisionIterable((class_1924)world, entity, box.method_1014(1.0E-7), includeWorldBorder);
        for (class_265 shape : collisions) {
            shapes.add(shape);
        }
        return shapes;
    }

    public static Iterable<class_265> getEntityWorldBorderCollisionIterable(final class_1924 view, final class_1297 entity, final class_238 box, final boolean includeWorldBorder) {
        assert (!includeWorldBorder || entity != null);
        return new Iterable<class_265>(){
            private List<class_1297> entityList;
            private int nextFilterIndex;

            @Override
            @NotNull
            public Iterator<class_265> iterator() {
                return new AbstractIterator<class_265>(){
                    int index = 0;
                    boolean consumedWorldBorder = false;

                    protected class_265 computeNext() {
                        class_1297 otherEntity;
                        if (entityList == null) {
                            entityList = WorldHelper.getEntitiesForCollision(view, box, entity);
                            nextFilterIndex = 0;
                        }
                        List<class_1297> list = entityList;
                        do {
                            if (this.index >= list.size()) {
                                if (includeWorldBorder && !this.consumedWorldBorder) {
                                    this.consumedWorldBorder = true;
                                    class_2784 worldBorder = entity.field_6002.method_8621();
                                    if (!LithiumEntityCollisions.isWithinWorldBorder(worldBorder, box) && LithiumEntityCollisions.isWithinWorldBorder(worldBorder, entity.method_5829())) {
                                        return worldBorder.method_17903();
                                    }
                                }
                                return (class_265)this.endOfData();
                            }
                            otherEntity = list.get(this.index);
                            if (this.index >= nextFilterIndex) {
                                if (entity == null) {
                                    if (!otherEntity.method_30948()) {
                                        otherEntity = null;
                                    }
                                } else if (!entity.method_30949(otherEntity)) {
                                    otherEntity = null;
                                }
                                ++nextFilterIndex;
                            }
                            ++this.index;
                        } while (otherEntity == null);
                        return class_259.method_1078((class_238)otherEntity.method_5829());
                    }
                };
            }
        };
    }

    public static boolean isWithinWorldBorder(class_2784 border, class_238 box) {
        double wboxMinX = Math.floor(border.method_11976());
        double wboxMinZ = Math.floor(border.method_11958());
        double wboxMaxX = Math.ceil(border.method_11963());
        double wboxMaxZ = Math.ceil(border.method_11977());
        return box.field_1323 >= wboxMinX && box.field_1323 <= wboxMaxX && box.field_1321 >= wboxMinZ && box.field_1321 <= wboxMaxZ && box.field_1320 >= wboxMinX && box.field_1320 <= wboxMaxX && box.field_1324 >= wboxMinZ && box.field_1324 <= wboxMaxZ;
    }

    private static boolean isBoxEmpty(class_238 box) {
        return box.method_995() <= 1.0E-7;
    }

    public static boolean doesEntityCollideWithWorldBorder(class_1941 collisionView, class_1297 entity) {
        if (LithiumEntityCollisions.isWithinWorldBorder(collisionView.method_8621(), entity.method_5829())) {
            return false;
        }
        class_265 worldBorderShape = LithiumEntityCollisions.getWorldBorderCollision(collisionView, entity);
        return worldBorderShape != null && class_259.method_1074((class_265)worldBorderShape, (class_265)class_259.method_1078((class_238)entity.method_5829()), (class_247)class_247.field_16896);
    }

    public static class_265 getWorldBorderCollision(class_1941 collisionView, class_1297 entity) {
        class_238 box = entity.method_5829();
        class_2784 worldBorder = collisionView.method_8621();
        return worldBorder.method_39459(entity, box) ? worldBorder.method_17903() : null;
    }
}

