/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.fabric.mixin.ClientEntityManagerAccessor;
import me.lucko.spark.fabric.mixin.ClientWorldAccessor;
import me.lucko.spark.fabric.mixin.ServerEntityManagerAccessor;
import me.lucko.spark.fabric.mixin.ServerWorldAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5579;
import net.minecraft.class_5582;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;

public abstract class FabricWorldInfoProvider
implements WorldInfoProvider {
    protected List<FabricChunkInfo> getChunksFromCache(class_5573<class_1297> cache) {
        LongSet loadedChunks = cache.method_31770();
        ArrayList<FabricChunkInfo> list = new ArrayList<FabricChunkInfo>(loadedChunks.size());
        LongIterator iterator = loadedChunks.iterator();
        while (iterator.hasNext()) {
            long chunkPos = iterator.nextLong();
            Stream sections = cache.method_31782(chunkPos);
            list.add(new FabricChunkInfo(chunkPos, sections));
        }
        return list;
    }

    static final class FabricChunkInfo
    extends AbstractChunkInfo<class_1299<?>> {
        private final CountMap<class_1299<?>> entityCounts = new CountMap.Simple(new HashMap());

        FabricChunkInfo(long chunkPos, Stream<class_5572<class_1297>> entities) {
            super(class_1923.method_8325((long)chunkPos), class_1923.method_8332((long)chunkPos));
            entities.forEach(section -> {
                if (section.method_31768().method_31885()) {
                    section.method_31766().forEach(entity -> this.entityCounts.increment(entity.method_5864()));
                }
            });
        }

        @Override
        public CountMap<class_1299<?>> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(class_1299<?> type) {
            return class_1299.method_5890(type).toString();
        }
    }

    public static final class Client
    extends FabricWorldInfoProvider {
        private final class_310 client;

        public Client(class_310 client) {
            this.client = client;
        }

        public WorldInfoProvider.Result<FabricChunkInfo> poll() {
            WorldInfoProvider.Result<FabricChunkInfo> data = new WorldInfoProvider.Result<FabricChunkInfo>();
            class_638 world = this.client.field_1687;
            if (world == null) {
                return null;
            }
            class_5582<class_1297> entityManager = ((ClientWorldAccessor)world).getEntityManager();
            class_5573<class_1297> cache = ((ClientEntityManagerAccessor)entityManager).getCache();
            List<FabricChunkInfo> list = this.getChunksFromCache(cache);
            data.put(world.method_27983().method_29177().method_12832(), list);
            return data;
        }
    }

    public static final class Server
    extends FabricWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        public WorldInfoProvider.Result<FabricChunkInfo> poll() {
            WorldInfoProvider.Result<FabricChunkInfo> data = new WorldInfoProvider.Result<FabricChunkInfo>();
            for (class_3218 world : this.server.method_3738()) {
                class_5579<class_1297> entityManager = ((ServerWorldAccessor)world).getEntityManager();
                class_5573<class_1297> cache = ((ServerEntityManagerAccessor)entityManager).getCache();
                List<FabricChunkInfo> list = this.getChunksFromCache(cache);
                data.put(world.method_27983().method_29177().method_12832(), list);
            }
            return data;
        }
    }
}

