/*
 * Decompiled with CFR 0.152.
 */
package org.lanternpowered.lmbda;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.lanternpowered.lmbda.ResolvedLambdaType;

public abstract class LambdaType<@NonNull T> {
    final @NonNull ResolvedLambdaType<T> resolved;
    final  @Nullable MethodHandles.Lookup defineLookup;

    public static <T> @NonNull LambdaType<T> of(@NonNull Class<T> functionType) {
        Objects.requireNonNull(functionType, "functionType");
        return new Simple(functionType);
    }

    public static <T> @NonNull LambdaType<T> of(@NonNull Type functionType) {
        Objects.requireNonNull(functionType, "functionType");
        return new Simple(functionType);
    }

    public LambdaType() {
        Class<?> theClass = this.getClass();
        Class<?> superClass = theClass.getSuperclass();
        if (superClass != LambdaType.class) {
            throw new IllegalStateException("Only direct subclasses of LambdaType are allowed.");
        }
        Type superType = theClass.getGenericSuperclass();
        if (!(superType instanceof ParameterizedType)) {
            throw new IllegalStateException("Direct subclasses of LambdaType must be a parameterized type.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)superType;
        this.resolved = new ResolvedLambdaType(parameterizedType.getActualTypeArguments()[0]);
        this.defineLookup = null;
    }

    private LambdaType(@NonNull ResolvedLambdaType<T> resolved,  @Nullable MethodHandles.Lookup defineLookup) {
        this.defineLookup = defineLookup;
        this.resolved = resolved;
    }

    public final @NonNull LambdaType<T> defineClassesWith( @NonNull MethodHandles.Lookup defineLookup) {
        Objects.requireNonNull(defineLookup, "defineLookup");
        return new Simple<T>(this.resolved, defineLookup);
    }

    public final @NonNull Class<T> getFunctionClass() {
        return this.resolved.functionClass;
    }

    public final @NonNull Type getFunctionType() {
        return this.resolved.getFunctionType();
    }

    public final @NonNull Method getMethod() {
        return this.resolved.getMethodCopy();
    }

    public final @NonNull String toString() {
        return this.resolved.toString();
    }

    public final boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LambdaType)) {
            return false;
        }
        LambdaType that = (LambdaType)obj;
        return that.resolved.equals(this.resolved) && Objects.equals(that.defineLookup, this.defineLookup);
    }

    public final int hashCode() {
        return Objects.hash(this.resolved, this.defineLookup);
    }

    protected final @NonNull Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Deprecated
    protected final void finalize() {
    }

    private static final class Simple<@NonNull T>
    extends LambdaType<T> {
        Simple(@NonNull Type functionType) {
            super(new ResolvedLambdaType(functionType), null);
        }

        Simple(@NonNull ResolvedLambdaType<T> resolved,  @Nullable MethodHandles.Lookup defineLookup) {
            super(resolved, defineLookup);
        }
    }
}

