/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.platform.fabric.world;

import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.nbt.NbtType;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_3722;
import net.minecraft.server.MinecraftServer;
import org.geysermc.geyser.level.GeyserWorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.LecternInventoryTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.platform.fabric.GeyserFabricMod;
import org.geysermc.platform.fabric.command.GeyserFabricCommandExecutor;

public class GeyserFabricWorldManager
extends GeyserWorldManager {
    private final MinecraftServer server;

    public GeyserFabricWorldManager(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public boolean shouldExpectLecternHandled() {
        return true;
    }

    @Override
    public NbtMap getLecternDataAt(GeyserSession session, int x, int y, int z, boolean isChunkLoad) {
        Runnable lecternGet = () -> {
            class_1657 player = this.getPlayer(session);
            if (player != null) {
                class_2586 blockEntity = player.field_6002.method_8321(new class_2338(x, y, z));
                if (!(blockEntity instanceof class_3722)) {
                    return;
                }
                class_3722 lectern = (class_3722)blockEntity;
                if (!lectern.method_17522()) {
                    if (!isChunkLoad) {
                        BlockEntityUtils.updateBlockEntity(session, LecternInventoryTranslator.getBaseLecternTag(x, y, z, 0).build(), Vector3i.from(x, y, z));
                    }
                    return;
                }
                class_1799 book = lectern.method_17520();
                int pageCount = class_1843.method_17443((class_1799)book);
                boolean hasBookPages = pageCount > 0;
                NbtMapBuilder lecternTag = LecternInventoryTranslator.getBaseLecternTag(x, y, z, hasBookPages ? pageCount : 1);
                lecternTag.putInt("page", lectern.method_17523() / 2);
                NbtMapBuilder bookTag = NbtMap.builder().putByte("Count", (byte)book.method_7947()).putShort("Damage", (short)0).putString("Name", "minecraft:writable_book");
                ArrayList<NbtMap> pages = new ArrayList<NbtMap>(hasBookPages ? pageCount : 1);
                if (hasBookPages && class_1840.method_8047((class_2487)book.method_7969())) {
                    class_2499 listTag = book.method_7969().method_10554("pages", 8);
                    for (int i = 0; i < listTag.size(); ++i) {
                        String page = listTag.method_10608(i);
                        NbtMapBuilder pageBuilder = NbtMap.builder().putString("photoname", "").putString("text", page);
                        pages.add(pageBuilder.build());
                    }
                } else {
                    NbtMapBuilder pageBuilder = NbtMap.builder().putString("photoname", "").putString("text", "");
                    pages.add(pageBuilder.build());
                }
                bookTag.putCompound("tag", NbtMap.builder().putList("pages", NbtType.COMPOUND, pages).build());
                lecternTag.putCompound("book", bookTag.build());
                NbtMap blockEntityTag = lecternTag.build();
                BlockEntityUtils.updateBlockEntity(session, blockEntityTag, Vector3i.from(x, y, z));
            }
        };
        if (isChunkLoad) {
            session.scheduleInEventLoop(() -> this.server.execute(lecternGet), 1L, TimeUnit.SECONDS);
        } else {
            this.server.execute(lecternGet);
        }
        return LecternInventoryTranslator.getBaseLecternTag(x, y, z, 0).build();
    }

    @Override
    public boolean hasPermission(GeyserSession session, String permission) {
        for (GeyserFabricCommandExecutor executor : GeyserFabricMod.getInstance().getCommandExecutors()) {
            if (!executor.getCommand().getPermission().equals(permission)) continue;
            return executor.canRun(this.getPlayer(session).method_5671());
        }
        return false;
    }

    private class_1657 getPlayer(GeyserSession session) {
        return this.server.method_3760().method_14602(session.getPlayerEntity().getUuid());
    }
}

