/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.platform.fabric;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2170;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.CommandManager;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.platform.fabric.GeyserFabricConfiguration;
import org.geysermc.platform.fabric.GeyserFabricDumpInfo;
import org.geysermc.platform.fabric.GeyserFabricLogger;
import org.geysermc.platform.fabric.GeyserFabricPermissions;
import org.geysermc.platform.fabric.GeyserServerPortGetter;
import org.geysermc.platform.fabric.command.GeyserFabricCommandExecutor;
import org.geysermc.platform.fabric.command.GeyserFabricCommandManager;
import org.geysermc.platform.fabric.world.GeyserFabricWorldManager;
import org.jetbrains.annotations.Nullable;

public class GeyserFabricMod
implements ModInitializer,
GeyserBootstrap {
    private static GeyserFabricMod instance;
    private boolean reloading;
    private GeyserImpl connector;
    private ModContainer mod;
    private Path dataFolder;
    private MinecraftServer server;
    private List<String> playerCommands;
    private final List<GeyserFabricCommandExecutor> commandExecutors = new ArrayList<GeyserFabricCommandExecutor>();
    private GeyserFabricCommandManager geyserCommandManager;
    private GeyserFabricConfiguration geyserConfig;
    private GeyserFabricLogger geyserLogger;
    private IGeyserPingPassthrough geyserPingPassthrough;
    private WorldManager geyserWorldManager;

    public void onInitialize() {
        instance = this;
        this.mod = (ModContainer)FabricLoader.getInstance().getModContainer("geyser-fabric").orElseThrow();
        this.onEnable();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerLifecycleEvents.SERVER_STARTED.register(this::startGeyser);
        }
    }

    @Override
    public void onEnable() {
        this.dataFolder = FabricLoader.getInstance().getConfigDir().resolve("Geyser-Fabric");
        if (!this.dataFolder.toFile().exists()) {
            this.dataFolder.toFile().mkdir();
        }
        GeyserLocale.init(this);
        try {
            File configFile = FileUtils.fileOrCopiedFromResource(this.dataFolder.resolve("config.yml").toFile(), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserFabricConfiguration.class);
            File permissionsFile = this.fileOrCopiedFromResource(this.dataFolder.resolve("permissions.yml").toFile(), "permissions.yml");
            this.playerCommands = Arrays.asList(FileUtils.loadConfig(permissionsFile, GeyserFabricPermissions.class).getCommands());
        }
        catch (IOException ex) {
            LogManager.getLogger((String)"geyser-fabric").error(GeyserLocale.getLocaleStringLog("geyser.config.failed", new Object[0]), (Throwable)ex);
            ex.printStackTrace();
            return;
        }
        this.geyserLogger = new GeyserFabricLogger(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        if (this.server == null) {
            ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.onDisable());
        } else {
            this.startGeyser(this.server);
            this.reloading = false;
        }
    }

    public void startGeyser(MinecraftServer server) {
        this.server = server;
        if (this.geyserConfig.getRemote().getAddress().equalsIgnoreCase("auto")) {
            this.geyserConfig.setAutoconfiguredRemote(true);
            String ip = server.method_3819();
            int port = ((GeyserServerPortGetter)server).geyser$getServerPort();
            if (ip != null && !ip.isEmpty() && !ip.equals("0.0.0.0")) {
                this.geyserConfig.getRemote().setAddress(ip);
            }
            this.geyserConfig.getRemote().setPort(port);
        }
        if (this.geyserConfig.getBedrock().isCloneRemotePort()) {
            this.geyserConfig.getBedrock().setPort(this.geyserConfig.getRemote().getPort());
        }
        Optional floodgate = FabricLoader.getInstance().getModContainer("floodgate");
        boolean floodgatePresent = floodgate.isPresent();
        if (this.geyserConfig.getRemote().getAuthType() == AuthType.FLOODGATE && !floodgatePresent) {
            this.geyserLogger.severe(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.not_installed", new Object[0]) + " " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.disabling", new Object[0]));
            return;
        }
        if (this.geyserConfig.isAutoconfiguredRemote() && floodgatePresent) {
            this.geyserLogger.debug("Auto-setting to Floodgate authentication.");
            this.geyserConfig.getRemote().setAuthType(AuthType.FLOODGATE);
        }
        this.geyserConfig.loadFloodgate(this, floodgate.orElse(null));
        this.connector = GeyserImpl.start(PlatformType.FABRIC, this);
        this.geyserPingPassthrough = GeyserLegacyPingPassthrough.init(this.connector);
        this.geyserCommandManager = new GeyserFabricCommandManager(this.connector);
        this.geyserWorldManager = new GeyserFabricWorldManager(server);
        GeyserFabricCommandExecutor helpExecutor = new GeyserFabricCommandExecutor(this.connector, this.connector.getCommandManager().getCommands().get("help"), !this.playerCommands.contains("help"));
        this.commandExecutors.add(helpExecutor);
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"geyser").executes((Command)helpExecutor);
        Iterator<Map.Entry<String, GeyserCommand>> iterator = this.connector.getCommandManager().getCommands().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, GeyserCommand> command;
            GeyserFabricCommandExecutor executor = new GeyserFabricCommandExecutor(this.connector, command.getValue(), !this.playerCommands.contains((command = iterator.next()).getKey()));
            this.commandExecutors.add(executor);
            builder.then(class_2170.method_9247((String)command.getKey()).executes((Command)executor));
        }
        server.method_3734().method_9235().register(builder);
    }

    @Override
    public void onDisable() {
        if (this.connector != null) {
            this.connector.shutdown();
            this.connector = null;
        }
        if (!this.reloading) {
            this.server = null;
        }
    }

    @Override
    public GeyserConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public CommandManager getGeyserCommandManager() {
        return this.geyserCommandManager;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserPingPassthrough;
    }

    @Override
    public WorldManager getWorldManager() {
        return this.geyserWorldManager;
    }

    @Override
    public Path getConfigFolder() {
        return this.dataFolder;
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserFabricDumpInfo(this.server);
    }

    @Override
    public String getMinecraftServerVersion() {
        return this.server.method_3827();
    }

    @Override
    @Nullable
    public InputStream getResourceOrNull(String resource) {
        Path path = this.mod.getPath(resource);
        try {
            return path.getFileSystem().provider().newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    private File fileOrCopiedFromResource(File file, String name) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            InputStream input = this.getResource(name);
            byte[] bytes = new byte[input.available()];
            input.read(bytes);
            for (char c : new String(bytes).toCharArray()) {
                fos.write(c);
            }
            fos.flush();
            input.close();
            fos.close();
        }
        return file;
    }

    public List<GeyserFabricCommandExecutor> getCommandExecutors() {
        return this.commandExecutors;
    }

    public static GeyserFabricMod getInstance() {
        return instance;
    }
}

