/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.platform.fabric;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.server.MinecraftServer;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.platform.fabric.ModInfo;

public class GeyserFabricDumpInfo
extends BootstrapDumpInfo {
    private String platformVersion = null;
    private final EnvType environmentType;
    private final String serverIP;
    private final int serverPort;
    private final List<ModInfo> mods;

    public GeyserFabricDumpInfo(MinecraftServer server) {
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            if (!modContainer.getMetadata().getId().equals("fabricloader")) continue;
            this.platformVersion = modContainer.getMetadata().getVersion().getFriendlyString();
            break;
        }
        this.environmentType = FabricLoader.getInstance().getEnvironmentType();
        this.serverIP = AsteriskSerializer.showSensitive || server.method_3819() == null || server.method_3819().equals("") || server.method_3819().equals("0.0.0.0") ? server.method_3819() : "***";
        this.serverPort = server.method_3756();
        this.mods = new ArrayList<ModInfo>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            this.mods.add(new ModInfo(mod));
        }
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public EnvType getEnvironmentType() {
        return this.environmentType;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public List<ModInfo> getMods() {
        return this.mods;
    }
}

