/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util.collection;

import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.LecternInventoryTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.collection.FixedInt2BooleanMap;

public class LecternHasBookMap
extends FixedInt2BooleanMap {
    public void handleBlockChange(GeyserSession session, int blockState, Vector3i position) {
        WorldManager worldManager = session.getGeyser().getWorldManager();
        int offset = blockState - this.start;
        if (offset < 0 || offset >= this.value.length) {
            if (!worldManager.shouldExpectLecternHandled()) {
                session.getLecternCache().remove(position);
            }
            return;
        }
        if (worldManager.shouldExpectLecternHandled()) {
            worldManager.getLecternDataAt(session, position.getX(), position.getY(), position.getZ(), false);
        } else {
            boolean newLecternHasBook = this.value[offset];
            if (newLecternHasBook != this.get(worldManager.getBlockAt(session, position))) {
                NbtMap newLecternTag;
                if (newLecternHasBook) {
                    newLecternTag = worldManager.getLecternDataAt(session, position.getX(), position.getY(), position.getZ(), false);
                } else {
                    session.getLecternCache().remove(position);
                    newLecternTag = LecternInventoryTranslator.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), 0).build();
                }
                BlockEntityUtils.updateBlockEntity(session, newLecternTag, position);
            }
        }
    }
}

