/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.data.game.level.sound.BuiltinSound;
import com.github.steveice10.mc.protocol.data.game.level.sound.CustomSound;
import com.github.steveice10.mc.protocol.data.game.level.sound.Sound;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.packet.LevelSoundEventPacket;
import com.nukkitx.protocol.bedrock.packet.PlaySoundPacket;
import java.util.Locale;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.SoundMapping;
import org.geysermc.geyser.session.GeyserSession;

public final class SoundUtils {
    private static SoundEvent toSoundEvent(String sound) {
        try {
            return SoundEvent.valueOf(sound.toUpperCase(Locale.ROOT).replace(".", "_"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String translatePlaySound(Sound sound) {
        SoundMapping soundMapping;
        String packetSound;
        Sound sound2 = sound;
        if (sound2 instanceof BuiltinSound) {
            BuiltinSound builtinSound = (BuiltinSound)sound2;
            packetSound = builtinSound.getName();
        } else {
            sound2 = sound;
            if (sound2 instanceof CustomSound) {
                CustomSound customSound = (CustomSound)sound2;
                packetSound = customSound.getName();
            } else {
                GeyserImpl.getInstance().getLogger().debug("Unknown sound, we were unable to map this. " + sound);
                return "";
            }
        }
        if (packetSound.startsWith("minecraft:")) {
            packetSound = packetSound.substring("minecraft:".length());
        }
        if ((soundMapping = (SoundMapping)Registries.SOUNDS.get(packetSound)) == null || soundMapping.getPlaysound() == null) {
            GeyserImpl.getInstance().getLogger().debug("[PlaySound] Defaulting to sound server gave us for " + sound);
            return packetSound;
        }
        return soundMapping.getPlaysound();
    }

    public static void playBuiltinSound(GeyserSession session, BuiltinSound javaSound, Vector3f position, float volume, float pitch) {
        String packetSound = javaSound.getName();
        SoundMapping soundMapping = (SoundMapping)Registries.SOUNDS.get(packetSound);
        if (soundMapping == null) {
            session.getGeyser().getLogger().debug("[Builtin] Sound mapping for " + packetSound + " not found");
            return;
        }
        if (soundMapping.getPlaysound() != null) {
            PlaySoundPacket playSoundPacket = new PlaySoundPacket();
            playSoundPacket.setSound(soundMapping.getPlaysound());
            playSoundPacket.setPosition(position);
            playSoundPacket.setVolume(volume);
            playSoundPacket.setPitch(pitch);
            session.sendUpstreamPacket(playSoundPacket);
            return;
        }
        if (soundMapping.isLevelEvent()) {
            LevelEventPacket levelEventPacket = new LevelEventPacket();
            levelEventPacket.setPosition(position);
            levelEventPacket.setData(0);
            levelEventPacket.setType(LevelEventType.valueOf(soundMapping.getBedrock()));
            session.sendUpstreamPacket(levelEventPacket);
            return;
        }
        LevelSoundEventPacket soundPacket = new LevelSoundEventPacket();
        SoundEvent sound = SoundUtils.toSoundEvent(soundMapping.getBedrock());
        if (sound == null) {
            sound = SoundUtils.toSoundEvent(packetSound);
        }
        if (sound == null) {
            session.getGeyser().getLogger().debug("[Builtin] Sound for original '" + packetSound + "' to mappings '" + soundMapping.getBedrock() + "' was not a playable level sound, or has yet to be mapped to an enum in SoundEvent.");
            return;
        }
        soundPacket.setSound(sound);
        soundPacket.setPosition(position);
        soundPacket.setIdentifier(soundMapping.getIdentifier());
        if (sound == SoundEvent.NOTE) {
            soundPacket.setExtraData(soundMapping.getExtraData() + (int)Math.round(Math.log10(pitch) / Math.log10(2.0) * 12.0) + 12);
        } else if (sound == SoundEvent.PLACE && soundMapping.getExtraData() == -1) {
            if (!soundMapping.getIdentifier().equals(":")) {
                int javaId = BlockRegistries.JAVA_IDENTIFIERS.getOrDefault(soundMapping.getIdentifier(), 0);
                soundPacket.setExtraData(session.getBlockMappings().getBedrockBlockId(javaId));
            } else {
                session.getGeyser().getLogger().debug("PLACE sound mapping identifier was invalid! Please report: " + soundMapping);
            }
            soundPacket.setIdentifier(":");
        } else {
            soundPacket.setExtraData(soundMapping.getExtraData());
        }
        soundPacket.setBabySound(false);
        soundPacket.setRelativeVolumeDisabled(false);
        session.sendUpstreamPacket(soundPacket);
    }

    private SoundUtils() {
    }
}

