/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.auth.service.MsaAuthenticationService;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.shaded.json.JSONObject;
import com.nimbusds.jose.shaded.json.JSONValue;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.packet.LoginPacket;
import com.nukkitx.protocol.bedrock.packet.ServerToClientHandshakePacket;
import com.nukkitx.protocol.bedrock.util.EncryptionUtils;
import java.io.IOException;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.crypto.SecretKey;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.response.result.FormResponseResult;
import org.geysermc.cumulus.response.result.ValidFormResponseResult;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.AuthData;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.relocate.jackson.databind.DeserializationFeature;
import org.geysermc.relocate.jackson.databind.JsonNode;
import org.geysermc.relocate.jackson.databind.ObjectMapper;
import org.geysermc.relocate.jackson.databind.node.JsonNodeType;

public class LoginEncryptionUtils {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static boolean HAS_SENT_ENCRYPTION_MESSAGE = false;

    private static boolean validateChainData(JsonNode data) throws Exception {
        if (data.size() != 3) {
            return false;
        }
        ECPublicKey lastKey = null;
        boolean mojangSigned = false;
        Iterator<JsonNode> iterator = data.iterator();
        while (iterator.hasNext()) {
            JsonNode node = iterator.next();
            JWSObject jwt = JWSObject.parse(node.asText());
            URI x5u = jwt.getHeader().getX509CertURL();
            if (x5u == null) {
                return false;
            }
            ECPublicKey expectedKey = EncryptionUtils.generateKey(jwt.getHeader().getX509CertURL().toString());
            if (lastKey == null) {
                lastKey = expectedKey;
            } else if (!lastKey.equals(expectedKey)) {
                return false;
            }
            if (!EncryptionUtils.verifyJwt(jwt, lastKey)) {
                return false;
            }
            if (mojangSigned) {
                return !iterator.hasNext();
            }
            if (lastKey.equals(EncryptionUtils.getMojangPublicKey())) {
                mojangSigned = true;
            }
            Object payload = JSONValue.parse(jwt.getPayload().toString());
            Preconditions.checkArgument(payload instanceof JSONObject, "Payload is not an object");
            Object identityPublicKey = ((JSONObject)payload).get("identityPublicKey");
            Preconditions.checkArgument(identityPublicKey instanceof String, "identityPublicKey node is missing in chain");
            lastKey = EncryptionUtils.generateKey((String)identityPublicKey);
        }
        return mojangSigned;
    }

    public static void encryptPlayerConnection(GeyserSession session, LoginPacket loginPacket) {
        JsonNode certData;
        try {
            certData = JSON_MAPPER.readTree(loginPacket.getChainData().toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException("Certificate JSON can not be read.");
        }
        JsonNode certChainData = certData.get("chain");
        if (certChainData.getNodeType() != JsonNodeType.ARRAY) {
            throw new RuntimeException("Certificate data is not valid");
        }
        LoginEncryptionUtils.encryptConnectionWithCert(session, loginPacket.getSkinData().toString(), certChainData);
    }

    private static void encryptConnectionWithCert(GeyserSession session, String clientData, JsonNode certChainData) {
        try {
            GeyserImpl geyser = session.getGeyser();
            boolean validChain = LoginEncryptionUtils.validateChainData(certChainData);
            geyser.getLogger().debug(String.format("Is player data valid? %s", validChain));
            if (!validChain && !session.getGeyser().getConfig().isEnableProxyConnections()) {
                session.disconnect(GeyserLocale.getLocaleStringLog("geyser.network.remote.invalid_xbox_account", new Object[0]));
                return;
            }
            JWSObject jwt = JWSObject.parse(certChainData.get(certChainData.size() - 1).asText());
            JsonNode payload = JSON_MAPPER.readTree(jwt.getPayload().toBytes());
            if (payload.get("extraData").getNodeType() != JsonNodeType.OBJECT) {
                throw new RuntimeException("AuthData was not found!");
            }
            JsonNode extraData = payload.get("extraData");
            session.setAuthenticationData(new AuthData(extraData.get("displayName").asText(), UUID.fromString(extraData.get("identity").asText()), extraData.get("XUID").asText()));
            session.setCertChainData(certChainData);
            if (payload.get("identityPublicKey").getNodeType() != JsonNodeType.STRING) {
                throw new RuntimeException("Identity Public Key was not found!");
            }
            ECPublicKey identityPublicKey = EncryptionUtils.generateKey(payload.get("identityPublicKey").textValue());
            JWSObject clientJwt = JWSObject.parse(clientData);
            EncryptionUtils.verifyJwt(clientJwt, identityPublicKey);
            JsonNode clientDataJson = JSON_MAPPER.readTree(clientJwt.getPayload().toBytes());
            BedrockClientData data = JSON_MAPPER.convertValue((Object)clientDataJson, BedrockClientData.class);
            data.setOriginalString(clientData);
            session.setClientData(data);
            if (EncryptionUtils.canUseEncryption()) {
                try {
                    LoginEncryptionUtils.startEncryptionHandshake(session, identityPublicKey);
                }
                catch (Throwable e) {
                    if (geyser.getConfig().isDebugMode()) {
                        e.printStackTrace();
                    }
                    LoginEncryptionUtils.sendEncryptionFailedMessage(geyser);
                }
            } else {
                LoginEncryptionUtils.sendEncryptionFailedMessage(geyser);
            }
        }
        catch (Exception ex) {
            session.disconnect("disconnectionScreen.internalError.cantConnect");
            throw new RuntimeException("Unable to complete login", ex);
        }
    }

    private static void startEncryptionHandshake(GeyserSession session, PublicKey key) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
        generator.initialize(new ECGenParameterSpec("secp384r1"));
        KeyPair serverKeyPair = generator.generateKeyPair();
        byte[] token = EncryptionUtils.generateRandomToken();
        SecretKey encryptionKey = EncryptionUtils.getSecretKey(serverKeyPair.getPrivate(), key, token);
        session.getUpstream().getSession().enableEncryption(encryptionKey);
        ServerToClientHandshakePacket packet = new ServerToClientHandshakePacket();
        packet.setJwt(EncryptionUtils.createHandshakeJwt(serverKeyPair, token).serialize());
        session.sendUpstreamPacketImmediately(packet);
    }

    private static void sendEncryptionFailedMessage(GeyserImpl geyser) {
        if (!HAS_SENT_ENCRYPTION_MESSAGE) {
            geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.encryption.line_1", new Object[0]));
            geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.encryption.line_2", "https://geysermc.org/supported_java"));
            HAS_SENT_ENCRYPTION_MESSAGE = true;
        }
    }

    public static void buildAndShowLoginWindow(GeyserSession session) {
        if (session.isLoggedIn()) {
            return;
        }
        session.setDaylightCycle(false);
        GeyserConfiguration config = session.getGeyser().getConfig();
        boolean isPasswordAuthEnabled = config.getRemote().isPasswordAuthentication();
        session.sendForm((FormBuilder<?, ?, ?>)((SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator((x$0, x$1) -> GeyserLocale.getPlayerLocaleString(x$0, x$1, new Object[0]), session.getLocale())).title("geyser.auth.login.form.notice.title")).content("geyser.auth.login.form.notice.desc").optionalButton("geyser.auth.login.form.notice.btn_login.mojang", isPasswordAuthEnabled).button("geyser.auth.login.form.notice.btn_login.microsoft").button("geyser.auth.login.form.notice.btn_disconnect").closedOrInvalidResultHandler(() -> LoginEncryptionUtils.buildAndShowLoginWindow(session))).validResultHandler(response -> {
            if (response.clickedButtonId() == 0) {
                session.setMicrosoftAccount(false);
                LoginEncryptionUtils.buildAndShowLoginDetailsWindow(session);
                return;
            }
            if (response.clickedButtonId() == 1) {
                if (isPasswordAuthEnabled) {
                    session.setMicrosoftAccount(true);
                    LoginEncryptionUtils.buildAndShowMicrosoftAuthenticationWindow(session);
                } else {
                    session.authenticateWithMicrosoftCode();
                }
                return;
            }
            session.disconnect(GeyserLocale.getPlayerLocaleString("geyser.auth.login.form.disconnect", session.getLocale(), new Object[0]));
        }));
    }

    public static void buildAndShowConsentWindow(GeyserSession session) {
        session.sendForm((FormBuilder<?, ?, ?>)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(LoginEncryptionUtils::translate, session.getLocale())).title("%gui.signIn")).content("geyser.auth.login.save_token.warning\n\ngeyser.auth.login.save_token.proceed").button("%gui.ok").button("%gui.decline").resultHandler(LoginEncryptionUtils.authenticateOrKickHandler(session)));
    }

    public static void buildAndShowTokenExpiredWindow(GeyserSession session) {
        session.sendForm((FormBuilder<?, ?, ?>)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(LoginEncryptionUtils::translate, session.getLocale())).title("geyser.auth.login.form.expired")).content("geyser.auth.login.save_token.expired\n\ngeyser.auth.login.save_token.proceed").button("%gui.ok").resultHandler(LoginEncryptionUtils.authenticateOrKickHandler(session)));
    }

    private static BiConsumer<SimpleForm, FormResponseResult<SimpleFormResponse>> authenticateOrKickHandler(GeyserSession session) {
        return (form, genericResult) -> {
            ValidFormResponseResult result;
            FormResponseResult result$temp = genericResult;
            if (result$temp instanceof ValidFormResponseResult && ((SimpleFormResponse)(result = (ValidFormResponseResult)result$temp).response()).clickedButtonId() == 0) {
                session.authenticateWithMicrosoftCode(true);
            } else {
                session.disconnect("%disconnect.quitting");
            }
        };
    }

    public static void buildAndShowLoginDetailsWindow(GeyserSession session) {
        session.sendForm((FormBuilder<?, ?, ?>)((CustomForm.Builder)((CustomForm.Builder)((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().translator((x$0, x$1) -> GeyserLocale.getPlayerLocaleString(x$0, x$1, new Object[0]), session.getLocale())).title("geyser.auth.login.form.details.title")).label("geyser.auth.login.form.details.desc").input("geyser.auth.login.form.details.email", "account@geysermc.org", "").input("geyser.auth.login.form.details.pass", "123456", "").invalidResultHandler(() -> LoginEncryptionUtils.buildAndShowLoginDetailsWindow(session))).closedResultHandler(() -> {
            if (session.isMicrosoftAccount()) {
                LoginEncryptionUtils.buildAndShowMicrosoftAuthenticationWindow(session);
            } else {
                LoginEncryptionUtils.buildAndShowLoginWindow(session);
            }
        })).validResultHandler(response -> session.authenticate((String)response.next(), (String)response.next())));
    }

    public static void buildAndShowMicrosoftAuthenticationWindow(GeyserSession session) {
        session.sendForm((FormBuilder<?, ?, ?>)((SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator((x$0, x$1) -> GeyserLocale.getPlayerLocaleString(x$0, x$1, new Object[0]), session.getLocale())).title("geyser.auth.login.form.notice.btn_login.microsoft")).button("geyser.auth.login.method.browser").button("geyser.auth.login.method.password").button("geyser.auth.login.form.notice.btn_disconnect").closedOrInvalidResultHandler(() -> LoginEncryptionUtils.buildAndShowLoginWindow(session))).validResultHandler(response -> {
            if (response.clickedButtonId() == 0) {
                session.authenticateWithMicrosoftCode();
            } else if (response.clickedButtonId() == 1) {
                LoginEncryptionUtils.buildAndShowLoginDetailsWindow(session);
            } else {
                session.disconnect(GeyserLocale.getPlayerLocaleString("geyser.auth.login.form.disconnect", session.getLocale(), new Object[0]));
            }
        }));
    }

    public static void buildAndShowMicrosoftCodeWindow(GeyserSession session, MsaAuthenticationService.MsCodeResponse msCode) {
        StringBuilder message = new StringBuilder("%xbox.signin.website\n").append("\u00a7b").append("%xbox.signin.url").append("\u00a7r").append("\n%xbox.signin.enterCode\n").append("\u00a7a").append(msCode.user_code);
        int timeout = session.getGeyser().getConfig().getPendingAuthenticationTimeout();
        if (timeout != 0) {
            message.append("\n\n").append("\u00a7r").append(GeyserLocale.getPlayerLocaleString("geyser.auth.login.timeout", session.getLocale(), String.valueOf(timeout)));
        }
        session.sendForm((FormBuilder<?, ?, ?>)((ModalForm.Builder)((ModalForm.Builder)ModalForm.builder().title("%xbox.signin")).content(message.toString()).button1("%gui.done").button2("%menu.disconnect").closedOrInvalidResultHandler(() -> LoginEncryptionUtils.buildAndShowMicrosoftAuthenticationWindow(session))).validResultHandler(response -> {
            if (response.clickedButtonId() == 1) {
                session.disconnect(GeyserLocale.getPlayerLocaleString("geyser.auth.login.form.disconnect", session.getLocale(), new Object[0]));
            }
        }));
    }

    private static String translate(String key, String locale) {
        StringBuilder newValue = new StringBuilder();
        int previousIndex = 0;
        while (previousIndex < key.length()) {
            int endIndex;
            int nextIndex = key.indexOf(10, previousIndex);
            int n = endIndex = nextIndex == -1 ? key.length() : nextIndex;
            if (endIndex - previousIndex > 1) {
                String substring = key.substring(previousIndex, endIndex);
                if (key.charAt(previousIndex) != '%') {
                    newValue.append(GeyserLocale.getPlayerLocaleString(substring, locale, new Object[0]));
                } else {
                    newValue.append(substring);
                }
            }
            newValue.append('\n');
            previousIndex = endIndex + 1;
        }
        return newValue.toString();
    }
}

