/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import javax.annotation.Nullable;
import org.geysermc.geyser.session.GeyserSession;

public class ItemUtils {
    private static Int2IntMap DYE_COLORS = null;

    public static int getEnchantmentLevel(@Nullable CompoundTag itemNBTData, String enchantmentId) {
        if (itemNBTData == null) {
            return 0;
        }
        ListTag enchantments = (ListTag)itemNBTData.get("Enchantments");
        if (enchantments != null) {
            for (Tag tag : enchantments) {
                Object object;
                Object lvl;
                CompoundTag enchantment = (CompoundTag)tag;
                StringTag enchantId = (StringTag)enchantment.get("id");
                if (!enchantId.getValue().equals(enchantmentId) || (lvl = enchantment.get("lvl")) == null || !((object = ((Tag)lvl).getValue()) instanceof Number)) continue;
                Number number = (Number)object;
                return number.intValue();
            }
        }
        return 0;
    }

    public static int getCorrectBedrockDurability(GeyserSession session, int javaId, int original) {
        if (javaId == session.getItemMappings().getStoredItems().fishingRod().getJavaId()) {
            return original * 6;
        }
        return original;
    }

    public static String getCustomName(CompoundTag itemTag) {
        CompoundTag displayTag;
        Object t2;
        Object t3;
        if (itemTag != null && (t3 = itemTag.get("display")) instanceof CompoundTag && (t2 = (displayTag = (CompoundTag)t3).get("Name")) instanceof StringTag) {
            StringTag nameTag = (StringTag)t2;
            return nameTag.getValue();
        }
        return null;
    }

    public static int dyeColorFor(int javaId) {
        return DYE_COLORS.get(javaId);
    }

    public static void setDyeColors(Int2IntMap dyeColors) {
        if (DYE_COLORS != null) {
            throw new RuntimeException();
        }
        dyeColors.defaultReturnValue(-1);
        DYE_COLORS = dyeColors;
    }
}

