/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.data.game.entity.Effect;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.Locale;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.ArmorStandEntity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;

public final class EntityUtils {
    public static final Hand[] HANDS = Hand.values();

    public static String[] getAllEffectIdentifiers() {
        String[] identifiers = new String[Effect.VALUES.length];
        for (int i = 0; i < Effect.VALUES.length; ++i) {
            identifiers[i] = "minecraft:" + Effect.VALUES[i].name().toLowerCase(Locale.ROOT);
        }
        return identifiers;
    }

    public static int toBedrockEffectId(Effect effect) {
        return switch (effect) {
            case Effect.GLOWING, Effect.LUCK, Effect.UNLUCK, Effect.DOLPHINS_GRACE -> 0;
            case Effect.LEVITATION -> 24;
            case Effect.CONDUIT_POWER -> 26;
            case Effect.SLOW_FALLING -> 27;
            case Effect.BAD_OMEN -> 28;
            case Effect.HERO_OF_THE_VILLAGE -> 29;
            case Effect.DARKNESS -> 30;
            default -> effect.ordinal() + 1;
        };
    }

    private static float getMountedHeightOffset(Entity mount) {
        float height = mount.getBoundingBoxHeight();
        float mountedHeightOffset = height * 0.75f;
        switch (mount.getDefinition().entityType()) {
            case CHICKEN: 
            case SPIDER: {
                mountedHeightOffset = height * 0.5f;
                break;
            }
            case DONKEY: 
            case MULE: {
                mountedHeightOffset -= 0.25f;
                break;
            }
            case TRADER_LLAMA: 
            case LLAMA: {
                mountedHeightOffset = height * 0.6f;
                break;
            }
            case MINECART: 
            case HOPPER_MINECART: 
            case TNT_MINECART: 
            case CHEST_MINECART: 
            case FURNACE_MINECART: 
            case SPAWNER_MINECART: 
            case COMMAND_BLOCK_MINECART: {
                mountedHeightOffset = 0.0f;
                break;
            }
            case BOAT: 
            case CHEST_BOAT: {
                mountedHeightOffset = -0.1f;
                break;
            }
            case HOGLIN: 
            case ZOGLIN: {
                boolean isBaby = mount.getFlag(EntityFlag.BABY);
                mountedHeightOffset = height - (isBaby ? 0.2f : 0.15f);
                break;
            }
            case PIGLIN: {
                mountedHeightOffset = height * 0.92f;
                break;
            }
            case RAVAGER: {
                mountedHeightOffset = 2.1f;
                break;
            }
            case SKELETON_HORSE: {
                mountedHeightOffset -= 0.1875f;
                break;
            }
            case STRIDER: {
                mountedHeightOffset = height - 0.19f;
            }
        }
        return mountedHeightOffset;
    }

    private static float getHeightOffset(Entity passenger) {
        switch (passenger.getDefinition().entityType()) {
            case SKELETON: 
            case STRAY: 
            case WITHER_SKELETON: {
                return -0.6f;
            }
            case ARMOR_STAND: {
                if (((ArmorStandEntity)passenger).isMarker()) {
                    return 0.0f;
                }
                return 0.1f;
            }
            case ENDERMITE: 
            case SILVERFISH: {
                return 0.1f;
            }
            case PIGLIN: 
            case PIGLIN_BRUTE: 
            case ZOMBIFIED_PIGLIN: {
                boolean isBaby = passenger.getFlag(EntityFlag.BABY);
                return isBaby ? -0.05f : -0.45f;
            }
            case ZOMBIE: {
                boolean isBaby = passenger.getFlag(EntityFlag.BABY);
                return isBaby ? 0.0f : -0.45f;
            }
            case RAVAGER: 
            case EVOKER: 
            case ILLUSIONER: 
            case PILLAGER: 
            case VINDICATOR: 
            case WITCH: {
                return -0.45f;
            }
            case PLAYER: {
                return -0.35f;
            }
        }
        if (passenger instanceof AnimalEntity) {
            return 0.14f;
        }
        return 0.0f;
    }

    public static void updateMountOffset(Entity passenger, Entity mount, boolean rider, boolean riding, boolean moreThanOneEntity) {
        passenger.setFlag(EntityFlag.RIDING, riding);
        if (riding) {
            Entity entity;
            float mountedHeightOffset = EntityUtils.getMountedHeightOffset(mount);
            float heightOffset = EntityUtils.getHeightOffset(passenger);
            float xOffset = 0.0f;
            float yOffset = mountedHeightOffset + heightOffset;
            float zOffset = 0.0f;
            switch (mount.getDefinition().entityType()) {
                case BOAT: {
                    if (rider && moreThanOneEntity) {
                        xOffset = 0.2f;
                        break;
                    }
                    if (!moreThanOneEntity) break;
                    xOffset = -0.6f;
                    break;
                }
                case CHEST_BOAT: {
                    xOffset = 0.15f;
                    break;
                }
                case CHICKEN: {
                    zOffset = -0.1f;
                    break;
                }
                case TRADER_LLAMA: 
                case LLAMA: {
                    zOffset = -0.3f;
                }
            }
            if (passenger.getDefinition().entityType() == EntityType.SHULKER) {
                switch (mount.getDefinition().entityType()) {
                    case MINECART: 
                    case HOPPER_MINECART: 
                    case TNT_MINECART: 
                    case CHEST_MINECART: 
                    case FURNACE_MINECART: 
                    case SPAWNER_MINECART: 
                    case COMMAND_BLOCK_MINECART: 
                    case BOAT: 
                    case CHEST_BOAT: {
                        yOffset = 0.1875f;
                    }
                }
            }
            if (passenger.getDefinition().entityType() == EntityType.PLAYER && mount.getDefinition().entityType() != EntityType.PLAYER && mount.getDefinition().entityType() != EntityType.AREA_EFFECT_CLOUD) {
                yOffset += EntityDefinitions.PLAYER.offset();
            }
            switch (mount.getDefinition().entityType()) {
                case MINECART: 
                case HOPPER_MINECART: 
                case TNT_MINECART: 
                case CHEST_MINECART: 
                case FURNACE_MINECART: 
                case SPAWNER_MINECART: 
                case COMMAND_BLOCK_MINECART: 
                case BOAT: 
                case CHEST_BOAT: {
                    yOffset -= mount.getDefinition().height() * 0.5f;
                }
            }
            if (passenger.getDefinition().entityType() == EntityType.FALLING_BLOCK) {
                yOffset += 0.5f;
            }
            if ((entity = mount) instanceof ArmorStandEntity) {
                ArmorStandEntity armorStand = (ArmorStandEntity)entity;
                yOffset -= armorStand.getYOffset();
            }
            Vector3f offset = Vector3f.from(xOffset, yOffset, zOffset);
            passenger.setRiderSeatPosition(offset);
        }
    }

    public static void updateRiderRotationLock(Entity passenger, Entity mount, boolean isRiding) {
        if (isRiding && mount instanceof BoatEntity) {
            passenger.getDirtyMetadata().put(EntityData.RIDER_ROTATION_LOCKED, (byte)1);
            passenger.getDirtyMetadata().put(EntityData.RIDER_MAX_ROTATION, Float.valueOf(90.0f));
            passenger.getDirtyMetadata().put(EntityData.RIDER_MIN_ROTATION, Float.valueOf(1.0f));
            passenger.getDirtyMetadata().put(EntityData.RIDER_ROTATION_OFFSET, Float.valueOf(-90.0f));
        } else {
            passenger.getDirtyMetadata().put(EntityData.RIDER_ROTATION_LOCKED, (byte)0);
            passenger.getDirtyMetadata().put(EntityData.RIDER_MAX_ROTATION, Float.valueOf(0.0f));
            passenger.getDirtyMetadata().put(EntityData.RIDER_MIN_ROTATION, Float.valueOf(0.0f));
            passenger.getDirtyMetadata().put(EntityData.RIDER_ROTATION_OFFSET, Float.valueOf(0.0f));
        }
    }

    public static boolean attemptToBucket(GeyserSession session, GeyserItemStack itemInHand) {
        return itemInHand.getJavaId() == session.getItemMappings().getStoredItems().waterBucket();
    }

    public static InteractionResult attemptToSaddle(GeyserSession session, Entity entityToSaddle, GeyserItemStack itemInHand) {
        if (itemInHand.getJavaId() == session.getItemMappings().getStoredItems().saddle() && !entityToSaddle.getFlag(EntityFlag.SADDLED) && !entityToSaddle.getFlag(EntityFlag.BABY)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private EntityUtils() {
    }
}

