/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.data.game.entity.Effect;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.packet.ChangeDimensionPacket;
import com.nukkitx.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import com.nukkitx.protocol.bedrock.packet.MobEffectPacket;
import com.nukkitx.protocol.bedrock.packet.StopSoundPacket;
import java.util.Set;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.EntityUtils;

public class DimensionUtils {
    private static int BEDROCK_NETHER_ID = 1;
    public static final String OVERWORLD = "minecraft:overworld";
    public static final String NETHER = "minecraft:the_nether";
    public static final String THE_END = "minecraft:the_end";

    public static void switchDimension(GeyserSession session, String javaDimension) {
        int bedrockDimension = DimensionUtils.javaToBedrock(javaDimension);
        int previousDimension = DimensionUtils.javaToBedrock(session.getDimension());
        SessionPlayerEntity player = session.getPlayerEntity();
        session.getChunkCache().clear();
        session.getEntityCache().removeAllEntities();
        session.getItemFrameCache().clear();
        if (session.getLecternCache() != null) {
            session.getLecternCache().clear();
        }
        session.getLodestoneCache().clear();
        session.getPistonCache().clear();
        session.getSkullCache().clear();
        if (session.getServerRenderDistance() > 47 && !session.isEmulatePost1_13Logic()) {
            session.getGeyser().getLogger().debug("Applying dimension switching workaround for Bedrock render distance of " + session.getServerRenderDistance());
            ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
            chunkRadiusUpdatedPacket.setRadius(47);
            session.sendUpstreamPacket(chunkRadiusUpdatedPacket);
        }
        Vector3f pos = Vector3f.from(0.0f, 32767.0f, 0.0f);
        ChangeDimensionPacket changeDimensionPacket = new ChangeDimensionPacket();
        changeDimensionPacket.setDimension(bedrockDimension);
        changeDimensionPacket.setRespawn(true);
        changeDimensionPacket.setPosition(pos);
        session.sendUpstreamPacket(changeDimensionPacket);
        session.setDimension(javaDimension);
        ((Entity)player).setPosition(pos);
        session.setSpawned(false);
        session.setLastChunkPosition(null);
        Set<Effect> entityEffects = session.getEffectCache().getEntityEffects();
        for (Effect effect : entityEffects) {
            MobEffectPacket mobEffectPacket = new MobEffectPacket();
            mobEffectPacket.setEvent(MobEffectPacket.Event.REMOVE);
            mobEffectPacket.setRuntimeEntityId(player.getGeyserId());
            mobEffectPacket.setEffectId(EntityUtils.toBedrockEffectId(effect));
            session.sendUpstreamPacket(mobEffectPacket);
        }
        entityEffects.clear();
        StopSoundPacket stopSoundPacket = new StopSoundPacket();
        stopSoundPacket.setStoppingAllSound(true);
        stopSoundPacket.setSoundName("");
        session.sendUpstreamPacket(stopSoundPacket);
        ChunkUtils.sendEmptyChunks(session, player.getPosition().toInt(), 3, true);
        if (BEDROCK_NETHER_ID == 2) {
            if (NETHER.equals(javaDimension)) {
                session.sendFog("minecraft:fog_hell");
            } else if (previousDimension == BEDROCK_NETHER_ID) {
                session.removeFog("minecraft:fog_hell");
            }
        }
    }

    public static int javaToBedrock(String javaDimension) {
        return switch (javaDimension) {
            case NETHER -> BEDROCK_NETHER_ID;
            case THE_END -> 2;
            default -> 0;
        };
    }

    public static void changeBedrockNetherId(boolean isAboveNetherBedrockBuilding) {
        BEDROCK_NETHER_ID = isAboveNetherBedrockBuilding ? 2 : 1;
    }

    public static String getTemporaryDimension(String currentDimension, String newDimension) {
        if (BEDROCK_NETHER_ID == 2) {
            return DimensionUtils.javaToBedrock(newDimension) == 2 ? OVERWORLD : NETHER;
        }
        return currentDimension.equals(OVERWORLD) ? NETHER : OVERWORLD;
    }

    public static boolean isCustomBedrockNetherId() {
        return BEDROCK_NETHER_ID == 2;
    }
}

