/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.nukkitx.math.vector.Vector2i;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.packet.LevelChunkPacket;
import com.nukkitx.protocol.bedrock.packet.NetworkChunkPublisherUpdatePacket;
import com.nukkitx.protocol.bedrock.packet.UpdateBlockPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.chunk.BlockStorage;
import org.geysermc.geyser.level.chunk.GeyserChunkSection;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.level.block.entity.BedrockOnlyBlockEntity;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.DimensionUtils;

public final class ChunkUtils {
    public static final byte[] SERIALIZED_CHUNK_DATA;
    public static final byte[] EMPTY_CHUNK_DATA;
    public static final byte[] EMPTY_BIOME_DATA;

    public static int indexYZXtoXZY(int yzx) {
        return yzx >> 8 | yzx & 0xF0 | (yzx & 0xF) << 8;
    }

    public static void updateChunkPosition(GeyserSession session, Vector3i position) {
        Vector2i chunkPos = session.getLastChunkPosition();
        Vector2i newChunkPos = Vector2i.from(position.getX() >> 4, position.getZ() >> 4);
        if (chunkPos == null || !chunkPos.equals(newChunkPos)) {
            NetworkChunkPublisherUpdatePacket chunkPublisherUpdatePacket = new NetworkChunkPublisherUpdatePacket();
            chunkPublisherUpdatePacket.setPosition(position);
            chunkPublisherUpdatePacket.setRadius(session.getServerRenderDistance() << 4);
            session.sendUpstreamPacket(chunkPublisherUpdatePacket);
            session.setLastChunkPosition(newChunkPos);
        }
    }

    public static void updateBlock(GeyserSession session, int blockState, Vector3i position) {
        ChunkUtils.updateBlockClientSide(session, blockState, position);
        session.getChunkCache().updateBlock(position.getX(), position.getY(), position.getZ(), blockState);
        session.getWorldCache().updateServerCorrectBlockState(position);
    }

    public static void updateBlockClientSide(GeyserSession session, int blockState, Vector3i position) {
        ItemFrameEntity itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, position);
        if (itemFrameEntity != null && blockState == 0) {
            itemFrameEntity.updateBlock(true);
            return;
        }
        if (BlockStateValues.getSkullVariant(blockState) == -1) {
            session.getSkullCache().removeSkull(position);
        }
        if (!BlockStateValues.isMovingPiston(blockState)) {
            int blockId = session.getBlockMappings().getBedrockBlockId(blockState);
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.setDataLayer(0);
            updateBlockPacket.setBlockPosition(position);
            updateBlockPacket.setRuntimeId(blockId);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
            session.sendUpstreamPacket(updateBlockPacket);
            UpdateBlockPacket waterPacket = new UpdateBlockPacket();
            waterPacket.setDataLayer(1);
            waterPacket.setBlockPosition(position);
            if (((IntSet)BlockRegistries.WATERLOGGED.get()).contains(blockState)) {
                waterPacket.setRuntimeId(session.getBlockMappings().getBedrockWaterId());
            } else {
                waterPacket.setRuntimeId(session.getBlockMappings().getBedrockAirId());
            }
            session.sendUpstreamPacket(waterPacket);
        }
        BlockStateValues.getLecternBookStates().handleBlockChange(session, blockState, position);
        for (BedrockOnlyBlockEntity bedrockOnlyBlockEntity : BlockEntityUtils.BEDROCK_ONLY_BLOCK_ENTITIES) {
            if (!bedrockOnlyBlockEntity.isBlock(blockState)) continue;
            bedrockOnlyBlockEntity.updateBlock(session, blockState, position);
            break;
        }
    }

    public static void sendEmptyChunk(GeyserSession session, int chunkX, int chunkZ, boolean forceUpdate) {
        LevelChunkPacket data = new LevelChunkPacket();
        data.setChunkX(chunkX);
        data.setChunkZ(chunkZ);
        data.setSubChunksLength(0);
        data.setData(EMPTY_CHUNK_DATA);
        data.setCachingEnabled(false);
        session.sendUpstreamPacket(data);
        if (forceUpdate) {
            Vector3i pos = Vector3i.from(chunkX << 4, 80, chunkZ << 4);
            UpdateBlockPacket blockPacket = new UpdateBlockPacket();
            blockPacket.setBlockPosition(pos);
            blockPacket.setDataLayer(0);
            blockPacket.setRuntimeId(1);
            session.sendUpstreamPacket(blockPacket);
        }
    }

    public static void sendEmptyChunks(GeyserSession session, Vector3i position, int radius, boolean forceUpdate) {
        int chunkX = position.getX() >> 4;
        int chunkZ = position.getZ() >> 4;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkUtils.sendEmptyChunk(session, chunkX + x, chunkZ + z, forceUpdate);
            }
        }
    }

    public static void loadDimension(GeyserSession session) {
        JavaDimension dimension = session.getDimensionType();
        int minY = dimension.minY();
        int maxY = dimension.maxY();
        if (minY % 16 != 0) {
            throw new RuntimeException("Minimum Y must be a multiple of 16!");
        }
        if (maxY % 16 != 0) {
            throw new RuntimeException("Maximum Y must be a multiple of 16!");
        }
        BedrockDimension bedrockDimension = switch (session.getDimension()) {
            case "minecraft:the_end" -> BedrockDimension.THE_END;
            case "minecraft:the_nether" -> {
                if (DimensionUtils.isCustomBedrockNetherId()) {
                    yield BedrockDimension.THE_END;
                }
                yield BedrockDimension.THE_NETHER;
            }
            default -> BedrockDimension.OVERWORLD;
        };
        session.getChunkCache().setBedrockDimension(bedrockDimension);
        if (minY < bedrockDimension.minY() || bedrockDimension.doUpperHeightWarn() && maxY > bedrockDimension.height()) {
            session.getGeyser().getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.translator.chunk.out_of_bounds", String.valueOf(bedrockDimension.minY()), String.valueOf(bedrockDimension.height()), session.getDimension()));
        }
        session.getChunkCache().setMinY(minY);
        session.getChunkCache().setHeightY(maxY);
        session.getWorldBorder().setWorldCoordinateScale(dimension.worldCoordinateScale());
    }

    private ChunkUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            new GeyserChunkSection(new BlockStorage[0]).writeToNetwork(byteBuf);
            SERIALIZED_CHUNK_DATA = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(SERIALIZED_CHUNK_DATA);
        }
        finally {
            byteBuf.release();
        }
        byteBuf = Unpooled.buffer();
        try {
            BlockStorage blockStorage = new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton((int)0));
            blockStorage.writeToNetwork(byteBuf);
            EMPTY_BIOME_DATA = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(EMPTY_BIOME_DATA);
        }
        finally {
            byteBuf.release();
        }
        byteBuf = Unpooled.buffer();
        try {
            for (int i = 0; i < 32; ++i) {
                byteBuf.writeBytes(EMPTY_BIOME_DATA);
            }
            byteBuf.writeByte(0);
            EMPTY_CHUNK_DATA = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(EMPTY_CHUNK_DATA);
        }
        finally {
            byteBuf.release();
        }
    }
}

