/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.sound;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.math.vector.Vector3f;
import java.util.Map;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.sound.SoundInteractionTranslator;
import org.geysermc.geyser.translator.sound.SoundTranslator;
import org.geysermc.geyser.util.BlockUtils;

public interface BlockSoundInteractionTranslator
extends SoundInteractionTranslator<String> {
    public static void handleBlockInteraction(GeyserSession session, Vector3f position, String identifier) {
        String handIdentifier = null;
        for (Map.Entry interactionEntry : ((Map)Registries.SOUND_TRANSLATORS.get()).entrySet()) {
            if (!(interactionEntry.getValue() instanceof BlockSoundInteractionTranslator)) continue;
            if (((SoundTranslator)interactionEntry.getKey()).blocks().length != 0) {
                boolean contains = false;
                for (String blockIdentifier : ((SoundTranslator)interactionEntry.getKey()).blocks()) {
                    if (!identifier.contains(blockIdentifier)) continue;
                    contains = true;
                    break;
                }
                if (!contains) continue;
            }
            GeyserItemStack itemInHand = session.getPlayerInventory().getItemInHand();
            if (((SoundTranslator)interactionEntry.getKey()).items().length != 0) {
                if (itemInHand.isEmpty()) continue;
                if (handIdentifier == null) {
                    handIdentifier = itemInHand.getMapping(session).getJavaIdentifier();
                }
                boolean contains = false;
                for (String itemIdentifier : ((SoundTranslator)interactionEntry.getKey()).items()) {
                    if (!handIdentifier.contains(itemIdentifier)) continue;
                    contains = true;
                    break;
                }
                if (!contains) continue;
            }
            if (session.isSneaking() && !((SoundTranslator)interactionEntry.getKey()).ignoreSneakingWhileHolding() && !itemInHand.isEmpty()) continue;
            ((BlockSoundInteractionTranslator)interactionEntry.getValue()).translate(session, position, identifier);
        }
    }

    public static boolean canInteract(GeyserSession session, GeyserItemStack itemInHand, String blockIdentifier) {
        if (session.getGameMode() != GameMode.ADVENTURE) {
            return true;
        }
        CompoundTag tag = itemInHand.getNbt();
        if (tag == null) {
            return false;
        }
        ListTag canPlaceOn = (ListTag)tag.get("CanPlaceOn");
        if (canPlaceOn == null || canPlaceOn.size() == 0) {
            return false;
        }
        String cleanIdentifier = BlockUtils.getCleanIdentifier(blockIdentifier);
        for (Tag t2 : canPlaceOn) {
            StringTag stringTag;
            Tag tag2 = t2;
            if (!(tag2 instanceof StringTag) || !cleanIdentifier.equals((stringTag = (StringTag)tag2).getValue())) continue;
            return true;
        }
        return false;
    }
}

