/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.scoreboard;

import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardAction;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardPosition;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard.ClientboundSetScorePacket;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundSetScorePacket.class)
public class JavaSetScoreTranslator
extends PacketTranslator<ClientboundSetScorePacket> {
    private final GeyserLogger logger = GeyserImpl.getInstance().getLogger();

    @Override
    public void translate(GeyserSession session, ClientboundSetScorePacket packet) {
        WorldCache worldCache = session.getWorldCache();
        Scoreboard scoreboard = worldCache.getScoreboard();
        int pps = worldCache.increaseAndGetScoreboardPacketsPerSecond();
        Objective objective = scoreboard.getObjective(packet.getObjective());
        if (objective == null && packet.getAction() != ScoreboardAction.REMOVE) {
            this.logger.info(GeyserLocale.getLocaleStringLog("geyser.network.translator.score.failed_objective", packet.getObjective()));
            return;
        }
        boolean isBelowName = objective != null && objective == scoreboard.getObjectiveSlots().get((Object)ScoreboardPosition.BELOW_NAME);
        switch (packet.getAction()) {
            case ADD_OR_UPDATE: {
                objective.setScore(packet.getEntry(), packet.getValue());
                if (!isBelowName) break;
                this.setBelowName(session, objective, packet.getEntry(), packet.getValue());
                break;
            }
            case REMOVE: {
                Objective belowName;
                if (packet.getObjective().isEmpty() && (belowName = scoreboard.getObjectiveSlots().get((Object)ScoreboardPosition.BELOW_NAME)) != null) {
                    this.setBelowName(session, belowName, packet.getEntry(), 0);
                }
                if (objective != null) {
                    objective.removeScore(packet.getEntry());
                    if (!isBelowName) break;
                    this.setBelowName(session, objective, packet.getEntry(), 0);
                    break;
                }
                for (Objective objective1 : scoreboard.getObjectives()) {
                    objective1.removeScore(packet.getEntry());
                }
                break;
            }
        }
        if (pps < ScoreboardUpdater.FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) {
            scoreboard.onUpdate();
        }
    }

    private void setBelowName(GeyserSession session, Objective objective, String username, int count) {
        PlayerEntity entity = this.getPlayerEntity(session, username);
        if (entity == null) {
            return;
        }
        String displayString = count + " " + objective.getDisplayName();
        entity.getDirtyMetadata().put(EntityData.SCORE_TAG, displayString);
        SetEntityDataPacket entityDataPacket = new SetEntityDataPacket();
        entityDataPacket.setRuntimeEntityId(entity.getGeyserId());
        entityDataPacket.getMetadata().put(EntityData.SCORE_TAG, (Object)displayString);
        session.sendUpstreamPacket(entityDataPacket);
    }

    private PlayerEntity getPlayerEntity(GeyserSession session, String username) {
        if (session.getPlayerEntity().getUsername().equals(username)) {
            return null;
        }
        for (PlayerEntity entity : session.getEntityCache().getAllPlayerEntities()) {
            if (!entity.getUsername().equals(username)) continue;
            if (entity.isValid()) {
                return entity;
            }
            return null;
        }
        return null;
    }
}

